/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.quality.db;

import com.axelor.apps.quality.db.QualityMeasuringPoint;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="QUALITY_QUALITY_PICTURES", indexes={@Index(columnList="name"), @Index(columnList="meta_file"), @Index(columnList="quality_measuring_point")})
public class QualityPictures
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="QUALITY_QUALITY_PICTURES_SEQ")
    @SequenceGenerator(name="QUALITY_QUALITY_PICTURES_SEQ", sequenceName="QUALITY_QUALITY_PICTURES_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    private String name;
    @Widget(title="File")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile metaFile;
    @Widget(title="Date")
    private LocalDate createDate;
    @Widget(title="Measuring points")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private QualityMeasuringPoint qualityMeasuringPoint;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public QualityPictures() {
    }

    public QualityPictures(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MetaFile getMetaFile() {
        return this.metaFile;
    }

    public void setMetaFile(MetaFile metaFile) {
        this.metaFile = metaFile;
    }

    public LocalDate getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(LocalDate createDate) {
        this.createDate = createDate;
    }

    public QualityMeasuringPoint getQualityMeasuringPoint() {
        return this.qualityMeasuringPoint;
    }

    public void setQualityMeasuringPoint(QualityMeasuringPoint qualityMeasuringPoint) {
        this.qualityMeasuringPoint = qualityMeasuringPoint;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof QualityPictures)) {
            return false;
        }
        QualityPictures other = (QualityPictures)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("createDate", (Object)this.getCreateDate()).omitNullValues().toString();
    }
}

