/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.quality.db;

import com.axelor.apps.quality.db.ControlPointModel;
import com.axelor.apps.quality.db.QualityCorrectiveAction;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="QUALITY_QUALITY_PROCESS", indexes={@Index(columnList="name"), @Index(columnList="code")})
public class QualityProcess
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="QUALITY_QUALITY_PROCESS_SEQ")
    @SequenceGenerator(name="QUALITY_QUALITY_PROCESS_SEQ", sequenceName="QUALITY_QUALITY_PROCESS_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Label")
    @NotNull
    private String name;
    @Widget(title="Code")
    private String code;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="qualityProcess", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ControlPointModel> controlPointModelList;
    @Widget(title="Optional control point list")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="optionalQualityProcess", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ControlPointModel> optionalControlPointModelList;
    @Widget(title="Corrective actions list")
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<QualityCorrectiveAction> qualityCorrectiveActionList;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public QualityProcess() {
    }

    public QualityProcess(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public List<ControlPointModel> getControlPointModelList() {
        return this.controlPointModelList;
    }

    public void setControlPointModelList(List<ControlPointModel> controlPointModelList) {
        this.controlPointModelList = controlPointModelList;
    }

    public void addControlPointModelListItem(ControlPointModel item) {
        if (this.getControlPointModelList() == null) {
            this.setControlPointModelList(new ArrayList<ControlPointModel>());
        }
        this.getControlPointModelList().add(item);
        item.setQualityProcess(this);
    }

    public void removeControlPointModelListItem(ControlPointModel item) {
        if (this.getControlPointModelList() == null) {
            return;
        }
        this.getControlPointModelList().remove((Object)item);
    }

    public void clearControlPointModelList() {
        if (this.getControlPointModelList() != null) {
            this.getControlPointModelList().clear();
        }
    }

    public List<ControlPointModel> getOptionalControlPointModelList() {
        return this.optionalControlPointModelList;
    }

    public void setOptionalControlPointModelList(List<ControlPointModel> optionalControlPointModelList) {
        this.optionalControlPointModelList = optionalControlPointModelList;
    }

    public void addOptionalControlPointModelListItem(ControlPointModel item) {
        if (this.getOptionalControlPointModelList() == null) {
            this.setOptionalControlPointModelList(new ArrayList<ControlPointModel>());
        }
        this.getOptionalControlPointModelList().add(item);
        item.setOptionalQualityProcess(this);
    }

    public void removeOptionalControlPointModelListItem(ControlPointModel item) {
        if (this.getOptionalControlPointModelList() == null) {
            return;
        }
        this.getOptionalControlPointModelList().remove((Object)item);
    }

    public void clearOptionalControlPointModelList() {
        if (this.getOptionalControlPointModelList() != null) {
            this.getOptionalControlPointModelList().clear();
        }
    }

    public List<QualityCorrectiveAction> getQualityCorrectiveActionList() {
        return this.qualityCorrectiveActionList;
    }

    public void setQualityCorrectiveActionList(List<QualityCorrectiveAction> qualityCorrectiveActionList) {
        this.qualityCorrectiveActionList = qualityCorrectiveActionList;
    }

    public void addQualityCorrectiveActionListItem(QualityCorrectiveAction item) {
        if (this.getQualityCorrectiveActionList() == null) {
            this.setQualityCorrectiveActionList(new ArrayList<QualityCorrectiveAction>());
        }
        this.getQualityCorrectiveActionList().add(item);
    }

    public void removeQualityCorrectiveActionListItem(QualityCorrectiveAction item) {
        if (this.getQualityCorrectiveActionList() == null) {
            return;
        }
        this.getQualityCorrectiveActionList().remove((Object)item);
    }

    public void clearQualityCorrectiveActionList() {
        if (this.getQualityCorrectiveActionList() != null) {
            this.getQualityCorrectiveActionList().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof QualityProcess)) {
            return false;
        }
        QualityProcess other = (QualityProcess)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("code", (Object)this.getCode()).omitNullValues().toString();
    }
}

