/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.quality.service;

import com.axelor.apps.message.db.Template;
import com.axelor.apps.message.service.TemplateMessageService;
import com.axelor.apps.quality.db.ControlPoint;
import com.axelor.apps.quality.db.ControlPointModel;
import com.axelor.apps.quality.db.QualityControl;
import com.axelor.apps.quality.db.QualityCorrectiveAction;
import com.axelor.apps.quality.db.QualityMeasuringPoint;
import com.axelor.apps.quality.db.QualityProcess;
import com.axelor.apps.quality.db.repo.ControlPointRepository;
import com.axelor.apps.quality.db.repo.QualityControlRepository;
import com.axelor.apps.quality.db.repo.QualityCorrectiveActionRepository;
import com.axelor.apps.quality.db.repo.QualityMeasuringPointRepository;
import com.axelor.apps.quality.service.QualityControlService;
import com.axelor.apps.quality.service.app.AppQualityService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.IOException;
import java.util.List;
import javax.mail.MessagingException;

public class QualityControlServiceImpl
implements QualityControlService {
    @Inject
    ControlPointRepository controlPointRepo;

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void preFillOperations(QualityControl qualityControl, QualityProcess process) throws AxelorException {
        ControlPoint point;
        List<ControlPointModel> controlPointModelList = process.getControlPointModelList();
        List<ControlPointModel> optionalControlPointModelList = process.getOptionalControlPointModelList();
        List<QualityCorrectiveAction> qualityCorrectiveActionList = process.getQualityCorrectiveActionList();
        if (controlPointModelList != null) {
            qualityControl.getControlPointList().clear();
            for (ControlPointModel model : controlPointModelList) {
                point = new ControlPoint();
                this.createControlPointListItem(model, point, qualityControl);
                qualityControl.addControlPointListItem(point);
            }
        }
        if (optionalControlPointModelList != null) {
            qualityControl.getOptionalControlPointList().clear();
            for (ControlPointModel model : optionalControlPointModelList) {
                point = new ControlPoint();
                this.createControlPointListItem(model, point, qualityControl);
                qualityControl.addOptionalControlPointListItem(point);
            }
        }
        if (qualityCorrectiveActionList != null) {
            qualityControl.getQualityCorrectiveActionList().clear();
            for (QualityCorrectiveAction qualityCorrectiveAction : qualityCorrectiveActionList) {
                qualityCorrectiveAction = (QualityCorrectiveAction)((Object)((QualityCorrectiveActionRepository)((Object)Beans.get(QualityCorrectiveActionRepository.class))).copy((Model)((Object)qualityCorrectiveAction), true));
                qualityControl.addQualityCorrectiveActionListItem(qualityCorrectiveAction);
            }
        }
    }

    @Transactional
    public void createControlPointListItem(ControlPointModel model, ControlPoint point, QualityControl qualityControl) {
        point.setStatusSelect(1);
        point.setName(model.getName());
        point.setSequence(model.getSequence());
        point.setNotes(model.getNotes());
        point.setControlFrequency(model.getControlFrequency());
        point.setControlPointType(model.getControlPointType());
        for (QualityMeasuringPoint measuringPoint : model.getMeasuringPointList()) {
            measuringPoint = (QualityMeasuringPoint)((Object)((QualityMeasuringPointRepository)((Object)Beans.get(QualityMeasuringPointRepository.class))).copy((Model)((Object)measuringPoint), true));
            point.addMeasuringPointListItem(measuringPoint);
        }
        point.setControlPointDate(qualityControl.getStartDate());
        this.controlPointRepo.save((Model)((Object)point));
    }

    @Override
    @Transactional
    public void preFillOperationsFromOptionals(QualityControl qualityControl, List<ControlPoint> optionalControlPointList) {
        for (ControlPoint optionalControlPoint : optionalControlPointList) {
            optionalControlPoint = (ControlPoint)((Object)((ControlPointRepository)((Object)Beans.get(ControlPointRepository.class))).copy((Model)((Object)optionalControlPoint), true));
            optionalControlPoint.setOptionalQualityControl(null);
            qualityControl.addControlPointListItem(optionalControlPoint);
        }
        ((QualityControlRepository)((Object)Beans.get(QualityControlRepository.class))).save((Model)((Object)qualityControl));
    }

    @Override
    public void sendEmail(QualityControl qualityControl) throws ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException, AxelorException {
        Template template = ((AppQualityService)Beans.get(AppQualityService.class)).getAppQuality().getQualityControlTemplate();
        if (template != null) {
            ((TemplateMessageService)Beans.get(TemplateMessageService.class)).generateAndSendMessage((Model)((Object)qualityControl), template);
        }
    }
}

