/*
 * Decompiled with CFR 0.152.
 */
package com.microtripit.mandrillapp.lutung.controller;

import com.microtripit.mandrillapp.lutung.controller.MandrillUtil;
import com.microtripit.mandrillapp.lutung.model.MandrillApiError;
import com.microtripit.mandrillapp.lutung.view.MandrillExportJobInfo;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;

public class MandrillExportsApi {
    private static final String rootUrl = "https://mandrillapp.com/api/1.0/";
    private final String key;

    public MandrillExportsApi(String key) {
        this.key = key;
    }

    public MandrillExportJobInfo info(String id) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("id", id);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/exports/info.json", params, MandrillExportJobInfo.class);
    }

    public MandrillExportJobInfo list() throws MandrillApiError, IOException {
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/exports/list.json", MandrillUtil.paramsWithKey(this.key), MandrillExportJobInfo.class);
    }

    public MandrillExportJobInfo rejects(String notifyEmail) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("notify_email", notifyEmail);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/exports/rejects.json", params, MandrillExportJobInfo.class);
    }

    public MandrillExportJobInfo whitelist(String notifyEmail) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("notify_email", notifyEmail);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/exports/whitelist.json", params, MandrillExportJobInfo.class);
    }

    public MandrillExportJobInfo activity(String notifyEmail, Date dateFrom, Date dateTo, Collection<String> tags, Collection<String> senders, Collection<String> states, Collection<String> apiKeys) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("notify_email", notifyEmail);
        params.put("date_from", dateFrom);
        params.put("date_to", dateTo);
        params.put("tags", tags);
        params.put("senders", senders);
        params.put("states", states);
        params.put("api_keys", apiKeys);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/exports/activity.json", params, MandrillExportJobInfo.class);
    }
}

