/*
 * Decompiled with CFR 0.152.
 */
package com.microtripit.mandrillapp.lutung.controller;

import com.microtripit.mandrillapp.lutung.controller.MandrillUtil;
import com.microtripit.mandrillapp.lutung.model.MandrillApiError;
import com.microtripit.mandrillapp.lutung.view.MandrillMessage;
import com.microtripit.mandrillapp.lutung.view.MandrillMessageContent;
import com.microtripit.mandrillapp.lutung.view.MandrillMessageInfo;
import com.microtripit.mandrillapp.lutung.view.MandrillMessageStatus;
import com.microtripit.mandrillapp.lutung.view.MandrillScheduledMessageInfo;
import com.microtripit.mandrillapp.lutung.view.MandrillSearchMessageParams;
import com.microtripit.mandrillapp.lutung.view.MandrillTimeSeries;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class MandrillMessagesApi {
    private static final String rootUrl = "https://mandrillapp.com/api/1.0/";
    private final String key;

    public MandrillMessagesApi(String key) {
        this.key = key;
    }

    public MandrillMessageStatus[] send(MandrillMessage m, Boolean async) throws MandrillApiError, IOException {
        return this.send(m, async, null, null);
    }

    public MandrillMessageStatus[] send(MandrillMessage m, Boolean async, String ipPool, Date sendAt) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("message", m);
        params.put("async", async);
        if (ipPool != null) {
            params.put("ip_pool", ipPool);
        }
        if (sendAt != null) {
            params.put("send_at", sendAt);
        }
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/messages/send.json", params, MandrillMessageStatus[].class);
    }

    public MandrillMessageStatus[] sendTemplate(String templateName, Map<String, String> templateContent, MandrillMessage m, Boolean async) throws MandrillApiError, IOException {
        return this.sendTemplate(templateName, templateContent, m, async, null, null);
    }

    public MandrillMessageStatus[] sendTemplate(String templateName, Map<String, String> templateContent, MandrillMessage m, Boolean async, String ipPool, Date sendAt) throws MandrillApiError, IOException {
        ArrayList<TemplateContent> contents;
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("template_name", templateName);
        if (templateContent == null) {
            contents = new ArrayList<TemplateContent>(1);
            contents.add(TemplateContent.create("satisfy_validation", ""));
        } else {
            contents = new ArrayList(templateContent.size());
            for (String name : templateContent.keySet()) {
                contents.add(TemplateContent.create(name, templateContent.get(name)));
            }
        }
        params.put("template_content", contents);
        params.put("message", m);
        params.put("async", async);
        if (ipPool != null) {
            params.put("ip_pool", ipPool);
        }
        if (sendAt != null) {
            params.put("send_at", sendAt);
        }
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/messages/send-template.json", params, MandrillMessageStatus[].class);
    }

    public MandrillMessageInfo[] search(MandrillSearchMessageParams search) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        if (search != null) {
            params.put("query", search.getQuery());
            params.put("date_from", search.getDateFrom());
            params.put("date_to", search.getDateTo());
            params.put("tags", search.getTags());
            params.put("senders", search.getSenders());
            params.put("api_keys", search.getApiKeys());
            params.put("limit", search.getLimit());
        }
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/messages/search.json", params, MandrillMessageInfo[].class);
    }

    public MandrillTimeSeries[] searchTimeSeries(MandrillSearchMessageParams search) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        if (search != null) {
            params.put("query", search.getQuery());
            params.put("date_from", search.getDateFrom());
            params.put("date_to", search.getDateTo());
            params.put("tags", search.getTags());
            params.put("senders", search.getSenders());
        }
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/messages/search-time-series.json", params, MandrillTimeSeries[].class);
    }

    public MandrillMessageInfo info(String id) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("id", id);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/messages/info.json", params, MandrillMessageInfo.class);
    }

    public MandrillMessageContent content(String id) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("id", id);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/messages/content.json", params, MandrillMessageContent.class);
    }

    public MandrillMessage parse(String rawMessage) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("raw_message", rawMessage);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/messages/parse.json", params, MandrillMessage.class);
    }

    public MandrillMessageStatus[] sendRaw(String fromEmail, String fromName, String rawMessage, Collection<String> to, Boolean async) throws MandrillApiError, IOException {
        return this.sendRaw(fromEmail, fromName, rawMessage, to, async, null, null, null);
    }

    public MandrillMessageStatus[] sendRaw(String fromEmail, String fromName, String rawMessage, Collection<String> to, Boolean async, String ipPool, Date sendAt, String returnPathDomain) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("raw_message", rawMessage);
        params.put("from_email", fromEmail);
        params.put("from_name", fromName);
        params.put("to", to);
        params.put("async", async);
        if (ipPool != null) {
            params.put("ip_pool", ipPool);
        }
        if (sendAt != null) {
            params.put("send_at", sendAt);
        }
        if (returnPathDomain != null) {
            params.put("return_path_domain", returnPathDomain);
        }
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/messages/send-raw.json", params, MandrillMessageStatus[].class);
    }

    public MandrillScheduledMessageInfo[] listScheduled(String to) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("to", to);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/messages/list-scheduled.json", params, MandrillScheduledMessageInfo[].class);
    }

    public MandrillScheduledMessageInfo cancelScheduled(String id) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("id", id);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/messages/cancel-scheduled.json", params, MandrillScheduledMessageInfo.class);
    }

    public MandrillScheduledMessageInfo reschedule(String id, Date send_at) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("id", id);
        params.put("send_at", send_at);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/messages/reschedule.json", params, MandrillScheduledMessageInfo.class);
    }

    public static final class TemplateContent {
        private String name;
        private String content;

        public final String getName() {
            return this.name;
        }

        public final String getContent() {
            return this.content;
        }

        protected static final TemplateContent create(String name, String content) {
            TemplateContent c = new TemplateContent();
            c.name = name;
            c.content = content;
            return c;
        }
    }
}

