/*
 * Decompiled with CFR 0.152.
 */
package com.microtripit.mandrillapp.lutung.controller;

import com.microtripit.mandrillapp.lutung.controller.MandrillUtil;
import com.microtripit.mandrillapp.lutung.model.MandrillApiError;
import com.microtripit.mandrillapp.lutung.view.MandrillDomain;
import com.microtripit.mandrillapp.lutung.view.MandrillSender;
import com.microtripit.mandrillapp.lutung.view.MandrillTimeSeries;
import java.io.IOException;
import java.util.HashMap;

public class MandrillSendersApi {
    private static final String rootUrl = "https://mandrillapp.com/api/1.0/";
    private final String key;

    public MandrillSendersApi(String key) {
        this.key = key;
    }

    public MandrillSender[] list() throws MandrillApiError, IOException {
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/senders/list.json", MandrillUtil.paramsWithKey(this.key), MandrillSender[].class);
    }

    public MandrillDomain[] domains() throws MandrillApiError, IOException {
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/senders/domains.json", MandrillUtil.paramsWithKey(this.key), MandrillDomain[].class);
    }

    public MandrillDomain addDomain(String domain) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("domain", domain);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/senders/add-domain.json", params, MandrillDomain.class);
    }

    public MandrillDomain checkDomain(String domain) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("domain", domain);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/senders/check-domain.json", params, MandrillDomain.class);
    }

    public MandrillDomain.MandrillDomainVerificationInfo verifyDomain(String domain, String mailbox) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("domain", domain);
        params.put("mailbox", mailbox);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/senders/verify-domain.json", params, MandrillDomain.MandrillDomainVerificationInfo.class);
    }

    public MandrillSender info(String address) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("address", address);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/senders/info.json", params, MandrillSender.class);
    }

    public MandrillTimeSeries[] timeSeries(String address) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("address", address);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/senders/time-series.json", params, MandrillTimeSeries[].class);
    }
}

