/*
 * Decompiled with CFR 0.152.
 */
package com.microtripit.mandrillapp.lutung.controller;

import com.microtripit.mandrillapp.lutung.controller.MandrillUtil;
import com.microtripit.mandrillapp.lutung.model.MandrillApiError;
import com.microtripit.mandrillapp.lutung.view.MandrillTimeSeries;
import com.microtripit.mandrillapp.lutung.view.MandrillUrl;
import java.io.IOException;
import java.util.HashMap;

public class MandrillUrlsApi {
    private static final String rootUrl = "https://mandrillapp.com/api/1.0/";
    private final String key;

    public MandrillUrlsApi(String key) {
        this.key = key;
    }

    public MandrillUrl[] list() throws MandrillApiError, IOException {
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/urls/list.json", MandrillUtil.paramsWithKey(this.key), MandrillUrl[].class);
    }

    public MandrillUrl[] search(String query) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("q", query);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/urls/search.json", params, MandrillUrl[].class);
    }

    public MandrillTimeSeries[] timeSeries(String url) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("url", url);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/urls/time-series.json", params, MandrillTimeSeries[].class);
    }
}

