/*
 * Decompiled with CFR 0.152.
 */
package com.microtripit.mandrillapp.lutung.controller;

import com.microtripit.mandrillapp.lutung.controller.MandrillUtil;
import com.microtripit.mandrillapp.lutung.model.MandrillApiError;
import com.microtripit.mandrillapp.lutung.view.MandrillWebhook;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class MandrillWebhooksApi {
    private static final String rootUrl = "https://mandrillapp.com/api/1.0/";
    private final String key;

    public MandrillWebhooksApi(String key) {
        this.key = key;
    }

    public MandrillWebhook[] list() throws MandrillApiError, IOException {
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/webhooks/list.json", MandrillUtil.paramsWithKey(this.key), MandrillWebhook[].class);
    }

    public MandrillWebhook add(String url, String event) throws MandrillApiError, IOException {
        ArrayList<String> events = new ArrayList<String>(1);
        events.add(event);
        return this.add(url, null, events);
    }

    public MandrillWebhook add(String url, Collection<String> events) throws MandrillApiError, IOException {
        return this.add(url, null, events);
    }

    public MandrillWebhook add(String url, String description, Collection<String> events) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("url", url);
        params.put("description", description);
        params.put("events", events);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/webhooks/add.json", params, MandrillWebhook.class);
    }

    public MandrillWebhook info(Integer id) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("id", id);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/webhooks/info.json", params, MandrillWebhook.class);
    }

    public MandrillWebhook update(Integer id, String url, String event) throws MandrillApiError, IOException {
        ArrayList<String> events = new ArrayList<String>(1);
        events.add(event);
        return this.update(id, url, events);
    }

    public MandrillWebhook update(Integer id, String url, Collection<String> events) throws MandrillApiError, IOException {
        return this.update(id, url, null, events);
    }

    public MandrillWebhook update(Integer id, String url, String description, Collection<String> events) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("id", id);
        params.put("url", url);
        params.put("description", description);
        params.put("events", events);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/webhooks/update.json", params, MandrillWebhook.class);
    }

    public MandrillWebhook delete(Integer id) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("id", id);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/webhooks/delete.json", params, MandrillWebhook.class);
    }
}

