/*
 * Decompiled with CFR 0.152.
 */
package com.microtripit.mandrillapp.lutung.controller;

import com.microtripit.mandrillapp.lutung.controller.MandrillUtil;
import com.microtripit.mandrillapp.lutung.model.MandrillApiError;
import com.microtripit.mandrillapp.lutung.model.MandrillHelperClasses;
import com.microtripit.mandrillapp.lutung.view.MandrillWhitelistEntry;
import java.io.IOException;
import java.util.HashMap;

public class MandrillWhitelistsApi {
    private static final String rootUrl = "https://mandrillapp.com/api/1.0/";
    private final String key;

    public MandrillWhitelistsApi(String key) {
        this.key = key;
    }

    public Boolean add(String email) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("email", email);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/whitelists/add.json", params, WhitelistsAddResponse.class).getWhether();
    }

    public MandrillWhitelistEntry[] list(String email) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("email", email);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/whitelists/list.json", params, MandrillWhitelistEntry[].class);
    }

    public Boolean delete(String email) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("email", email);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/whitelists/delete.json", params, WhitelistsDeleteResponse.class).getDeleted();
    }

    public static class WhitelistsDeleteResponse {
        private Boolean deleted;

        public Boolean getDeleted() {
            return this.deleted;
        }
    }

    public static class WhitelistsAddResponse
    extends MandrillHelperClasses.EmailClass {
        private Boolean whether;

        public Boolean getWhether() {
            return this.whether;
        }
    }
}

