/*
 * Decompiled with CFR 0.152.
 */
package com.microtripit.mandrillapp.lutung.model;

import com.google.gson.Gson;
import com.microtripit.mandrillapp.lutung.model.LutungGsonUtils;

public class MandrillApiError
extends Exception {
    private static final long serialVersionUID = 1L;
    private MandrillError error;

    public MandrillApiError() {
    }

    public MandrillApiError(String msg) {
        super(msg);
    }

    public MandrillApiError(Throwable t) {
        super(t);
    }

    public MandrillApiError(String msg, Throwable t) {
        super(msg, t);
    }

    public final String getMandrillErrorStatus() {
        return this.error.getStatus();
    }

    public final boolean hasMandrillErrorStatus() {
        return this.error != null && this.error.hasStatus();
    }

    public final String getMandrillErrorName() {
        return this.error.getName();
    }

    public final boolean hasMandrillErrorName() {
        return this.error != null && this.error.hasName();
    }

    public final String getMandrillErrorMessage() {
        return this.error.getMessage();
    }

    public final boolean hasMandrillErrorMessage() {
        return this.error != null && this.error.hasMessage();
    }

    public final Integer getMandrillErrorCode() {
        return this.error.getCode();
    }

    public final boolean hasMandrillErrorCode() {
        return this.error != null && this.error.hasCode();
    }

    public final String getMandrillErrorAsJson() {
        if (this.error != null) {
            Gson gson = LutungGsonUtils.createGsonBuilder().setPrettyPrinting().create();
            return gson.toJson((Object)this.error);
        }
        return "{}";
    }

    protected final MandrillApiError withError(MandrillError error) {
        this.error = error;
        return this;
    }

    public static final class MandrillError {
        private String status;
        private String name;
        private String message;
        private Integer code;

        public MandrillError(String status, String name, String message, Integer code) {
            this.status = status;
            this.name = name;
            this.message = message;
            this.code = code;
        }

        public final String getStatus() {
            return this.status;
        }

        public final boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public final String getName() {
            return this.name;
        }

        public final boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public final String getMessage() {
            return this.message;
        }

        public final boolean hasMessage() {
            return this.message != null && !this.message.isEmpty();
        }

        public final Integer getCode() {
            return this.code;
        }

        public final boolean hasCode() {
            return this.code != null;
        }
    }
}

