/*
 * Decompiled with CFR 0.152.
 */
package com.microtripit.mandrillapp.lutung.model;

import com.microtripit.mandrillapp.lutung.logging.Logger;
import com.microtripit.mandrillapp.lutung.logging.LoggerFactory;
import com.microtripit.mandrillapp.lutung.model.HandleResponseException;
import com.microtripit.mandrillapp.lutung.model.LutungGsonUtils;
import com.microtripit.mandrillapp.lutung.model.MandrillApiError;
import com.microtripit.mandrillapp.lutung.model.RequestModel;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public final class MandrillRequestDispatcher {
    private static final Logger log = LoggerFactory.getLogger(MandrillRequestDispatcher.class);
    public static int SOCKET_TIMEOUT_MILLIS = 0;
    public static int CONNECTION_TIMEOUT_MILLIS = 0;

    public static final <T> T execute(RequestModel<T> requestModel, HttpClient client) throws MandrillApiError, IOException {
        Object proxy;
        HttpResponse response = null;
        InputStream responseInputStream = null;
        if (client == null) {
            log.debug("Using new instance of default http client");
            client = new DefaultHttpClient();
            client.getParams().setParameter("http.useragent", (Object)(client.getParams().getParameter("http.useragent") + "/Lutung-0.1"));
            ProxyData proxyData = MandrillRequestDispatcher.detectProxyServer(requestModel.getUrl());
            if (proxyData != null) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Using proxy @" + proxyData.host + ":" + String.valueOf(proxyData.port), new Object[0]));
                }
                proxy = new HttpHost(proxyData.host, proxyData.port);
                client.getParams().setParameter("http.route.default-proxy", proxy);
            }
            HttpConnectionParams.setSoTimeout((HttpParams)client.getParams(), (int)SOCKET_TIMEOUT_MILLIS);
            HttpConnectionParams.setConnectionTimeout((HttpParams)client.getParams(), (int)CONNECTION_TIMEOUT_MILLIS);
        }
        log.debug("starting request '" + requestModel.getUrl() + "'");
        response = client.execute((HttpUriRequest)requestModel.getRequest());
        StatusLine status = response.getStatusLine();
        responseInputStream = response.getEntity().getContent();
        if (requestModel.validateResponseStatus(status.getStatusCode())) {
            try {
                proxy = requestModel.handleResponse(responseInputStream);
            }
            catch (HandleResponseException e) {
                throw new IOException("Failed to parse response from request '" + requestModel.getUrl() + "'", e);
            }
            return proxy;
        }
        String e = IOUtils.toString((InputStream)responseInputStream);
        MandrillApiError.MandrillError error = null;
        try {
            error = (MandrillApiError.MandrillError)LutungGsonUtils.getGson().fromJson(e, MandrillApiError.MandrillError.class);
        }
        catch (Throwable ex) {
            error = new MandrillApiError.MandrillError("Invalid Error Format", "Invalid Error Format", e, status.getStatusCode());
        }
        throw new MandrillApiError("Unexpected http status in response: " + status.getStatusCode() + " (" + status.getReasonPhrase() + ")").withError(error);
        finally {
            if (responseInputStream != null) {
                responseInputStream.close();
            }
            if (response != null) {
                MandrillRequestDispatcher.consume(response.getEntity());
            }
        }
    }

    private static final ProxyData detectProxyServer(String url) {
        try {
            List<Proxy> proxies = ProxySelector.getDefault().select(new URI(url));
            if (proxies != null) {
                for (Proxy proxy : proxies) {
                    InetSocketAddress addr = (InetSocketAddress)proxy.address();
                    if (addr == null) continue;
                    return new ProxyData(addr.getHostName(), addr.getPort());
                }
            }
            return null;
        }
        catch (Throwable t) {
            log.error("Error detecting proxy server", t);
            return null;
        }
    }

    private static void consume(HttpEntity entity) throws IOException {
        InputStream inputStream;
        if (entity == null) {
            return;
        }
        if (entity.isStreaming() && (inputStream = entity.getContent()) != null) {
            inputStream.close();
        }
    }

    private static final class ProxyData {
        String host;
        int port;

        protected ProxyData(String host, int port) {
            this.host = host;
            this.port = port;
        }
    }
}

