/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.dbsupport;

import java.sql.SQLException;
import org.flywaydb.core.internal.dbsupport.FlywaySqlException;
import org.flywaydb.core.internal.dbsupport.SqlStatement;
import org.flywaydb.core.internal.util.scanner.Resource;

public class FlywaySqlScriptException
extends FlywaySqlException {
    private final Resource resource;
    private final SqlStatement statement;

    public FlywaySqlScriptException(Resource resource, SqlStatement statement, SQLException sqlException) {
        super(resource == null ? "Script failed" : "Migration " + resource.getFilename() + " failed", sqlException);
        this.resource = resource;
        this.statement = statement;
    }

    public int getLineNumber() {
        return this.statement.getLineNumber();
    }

    public String getStatement() {
        return this.statement.getSql();
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        if (this.resource != null) {
            message = message + "Location   : " + this.resource.getLocation() + " (" + this.resource.getLocationOnDisk() + ")\n";
        }
        message = message + "Line       : " + this.getLineNumber() + "\n";
        message = message + "Statement  : " + this.getStatement() + "\n";
        return message;
    }
}

