/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.db;

import com.axelor.apps.base.db.Currency;
import com.axelor.apps.production.db.BillOfMaterial;
import com.axelor.apps.production.db.CostSheetLine;
import com.axelor.apps.production.db.ManufOrder;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import org.hibernate.annotations.Type;

@Entity
@Table(name="PRODUCTION_COST_SHEET", indexes={@Index(columnList="bill_of_material"), @Index(columnList="manuf_order"), @Index(columnList="currency")})
public class CostSheet
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PRODUCTION_COST_SHEET_SEQ")
    @SequenceGenerator(name="PRODUCTION_COST_SHEET_SEQ", sequenceName="PRODUCTION_COST_SHEET_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="BillOfMaterial")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BillOfMaterial billOfMaterial;
    @Widget(title="ManufOrder")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ManufOrder manufOrder;
    @Widget(title="Cost sheet lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="costSheet", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<CostSheetLine> costSheetLineList;
    @Widget(title="Cost price")
    @Digits(integer=10, fraction=10)
    private BigDecimal costPrice = BigDecimal.ZERO;
    @Widget(title="Currency")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency currency;
    @Widget(title="Calculation type", selection="production.cost.sheet.calculation.type.select")
    private Integer calculationTypeSelect = 0;
    @Widget(title="Date of calculation")
    private LocalDate calculationDate;
    @Widget(title="Produced ratio")
    @Digits(integer=15, fraction=5)
    private BigDecimal manufOrderProducedRatio = BigDecimal.ZERO;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public BillOfMaterial getBillOfMaterial() {
        return this.billOfMaterial;
    }

    public void setBillOfMaterial(BillOfMaterial billOfMaterial) {
        this.billOfMaterial = billOfMaterial;
    }

    public ManufOrder getManufOrder() {
        return this.manufOrder;
    }

    public void setManufOrder(ManufOrder manufOrder) {
        this.manufOrder = manufOrder;
    }

    public List<CostSheetLine> getCostSheetLineList() {
        return this.costSheetLineList;
    }

    public void setCostSheetLineList(List<CostSheetLine> costSheetLineList) {
        this.costSheetLineList = costSheetLineList;
    }

    public void addCostSheetLineListItem(CostSheetLine item) {
        if (this.getCostSheetLineList() == null) {
            this.setCostSheetLineList(new ArrayList<CostSheetLine>());
        }
        this.getCostSheetLineList().add(item);
        item.setCostSheet(this);
    }

    public void removeCostSheetLineListItem(CostSheetLine item) {
        if (this.getCostSheetLineList() == null) {
            return;
        }
        this.getCostSheetLineList().remove((Object)item);
    }

    public void clearCostSheetLineList() {
        if (this.getCostSheetLineList() != null) {
            this.getCostSheetLineList().clear();
        }
    }

    public BigDecimal getCostPrice() {
        return this.costPrice == null ? BigDecimal.ZERO : this.costPrice;
    }

    public void setCostPrice(BigDecimal costPrice) {
        this.costPrice = costPrice;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public Integer getCalculationTypeSelect() {
        return this.calculationTypeSelect == null ? 0 : this.calculationTypeSelect;
    }

    public void setCalculationTypeSelect(Integer calculationTypeSelect) {
        this.calculationTypeSelect = calculationTypeSelect;
    }

    public LocalDate getCalculationDate() {
        return this.calculationDate;
    }

    public void setCalculationDate(LocalDate calculationDate) {
        this.calculationDate = calculationDate;
    }

    public BigDecimal getManufOrderProducedRatio() {
        return this.manufOrderProducedRatio == null ? BigDecimal.ZERO : this.manufOrderProducedRatio;
    }

    public void setManufOrderProducedRatio(BigDecimal manufOrderProducedRatio) {
        this.manufOrderProducedRatio = manufOrderProducedRatio;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CostSheet)) {
            return false;
        }
        CostSheet other = (CostSheet)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("costPrice", (Object)this.getCostPrice()).add("calculationTypeSelect", (Object)this.getCalculationTypeSelect()).add("calculationDate", (Object)this.getCalculationDate()).add("manufOrderProducedRatio", (Object)this.getManufOrderProducedRatio()).omitNullValues().toString();
    }
}

