/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.db;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.production.db.CostSheet;
import com.axelor.apps.production.db.CostSheetGroup;
import com.axelor.apps.production.db.WorkCenter;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import org.hibernate.annotations.Type;

@Entity
@Table(name="PRODUCTION_COST_SHEET_LINE", indexes={@Index(columnList="cost_sheet"), @Index(columnList="product"), @Index(columnList="work_center"), @Index(columnList="cost_sheet_group"), @Index(columnList="unit"), @Index(columnList="parent_cost_sheet_line"), @Index(columnList="code"), @Index(columnList="name")})
public class CostSheetLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PRODUCTION_COST_SHEET_LINE_SEQ")
    @SequenceGenerator(name="PRODUCTION_COST_SHEET_LINE_SEQ", sequenceName="PRODUCTION_COST_SHEET_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="CostSheet")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private CostSheet costSheet;
    @Widget(title="Product")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="WorkCenter")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private WorkCenter workCenter;
    @Widget(title="Level")
    private Integer bomLevel = 0;
    @Widget(title="Cost sheet group")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private CostSheetGroup costSheetGroup;
    @Widget(title="Consumption")
    @Digits(integer=10, fraction=10)
    private BigDecimal consumptionQty = BigDecimal.ZERO;
    @Widget(title="Unit")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit unit;
    @Widget(title="Cost price")
    @Digits(integer=10, fraction=10)
    private BigDecimal costPrice = BigDecimal.ZERO;
    @Widget(title="Parent")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private CostSheetLine parentCostSheetLine;
    @Widget(title="Parent")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="parentCostSheetLine", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<CostSheetLine> costSheetLineList;
    @Widget(title="Type", selection="production.cost.sheet.line.type.select")
    private Integer typeSelect = 0;
    @Widget(title="Code")
    private String code;
    @Widget(title="name")
    private String name;
    @Widget(selection="production.cost.sheet.line.type.select")
    private Integer typeSelectIcon = 0;
    @Widget(title="Unit cost price")
    @Digits(integer=10, fraction=10)
    private BigDecimal unitCostPrice = BigDecimal.ZERO;
    @Widget(title="Ratio")
    @Digits(integer=10, fraction=10)
    private BigDecimal ratio = BigDecimal.ZERO;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public CostSheetLine() {
    }

    public CostSheetLine(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public CostSheet getCostSheet() {
        return this.costSheet;
    }

    public void setCostSheet(CostSheet costSheet) {
        this.costSheet = costSheet;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public WorkCenter getWorkCenter() {
        return this.workCenter;
    }

    public void setWorkCenter(WorkCenter workCenter) {
        this.workCenter = workCenter;
    }

    public Integer getBomLevel() {
        return this.bomLevel == null ? 0 : this.bomLevel;
    }

    public void setBomLevel(Integer bomLevel) {
        this.bomLevel = bomLevel;
    }

    public CostSheetGroup getCostSheetGroup() {
        return this.costSheetGroup;
    }

    public void setCostSheetGroup(CostSheetGroup costSheetGroup) {
        this.costSheetGroup = costSheetGroup;
    }

    public BigDecimal getConsumptionQty() {
        return this.consumptionQty == null ? BigDecimal.ZERO : this.consumptionQty;
    }

    public void setConsumptionQty(BigDecimal consumptionQty) {
        this.consumptionQty = consumptionQty;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public BigDecimal getCostPrice() {
        return this.costPrice == null ? BigDecimal.ZERO : this.costPrice;
    }

    public void setCostPrice(BigDecimal costPrice) {
        this.costPrice = costPrice;
    }

    public CostSheetLine getParentCostSheetLine() {
        return this.parentCostSheetLine;
    }

    public void setParentCostSheetLine(CostSheetLine parentCostSheetLine) {
        this.parentCostSheetLine = parentCostSheetLine;
    }

    public List<CostSheetLine> getCostSheetLineList() {
        return this.costSheetLineList;
    }

    public void setCostSheetLineList(List<CostSheetLine> costSheetLineList) {
        this.costSheetLineList = costSheetLineList;
    }

    public void addCostSheetLineListItem(CostSheetLine item) {
        if (this.getCostSheetLineList() == null) {
            this.setCostSheetLineList(new ArrayList<CostSheetLine>());
        }
        this.getCostSheetLineList().add(item);
        item.setParentCostSheetLine(this);
    }

    public void removeCostSheetLineListItem(CostSheetLine item) {
        if (this.getCostSheetLineList() == null) {
            return;
        }
        this.getCostSheetLineList().remove((Object)item);
    }

    public void clearCostSheetLineList() {
        if (this.getCostSheetLineList() != null) {
            this.getCostSheetLineList().clear();
        }
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getTypeSelectIcon() {
        return this.typeSelectIcon == null ? 0 : this.typeSelectIcon;
    }

    public void setTypeSelectIcon(Integer typeSelectIcon) {
        this.typeSelectIcon = typeSelectIcon;
    }

    public BigDecimal getUnitCostPrice() {
        return this.unitCostPrice == null ? BigDecimal.ZERO : this.unitCostPrice;
    }

    public void setUnitCostPrice(BigDecimal unitCostPrice) {
        this.unitCostPrice = unitCostPrice;
    }

    public BigDecimal getRatio() {
        return this.ratio == null ? BigDecimal.ZERO : this.ratio;
    }

    public void setRatio(BigDecimal ratio) {
        this.ratio = ratio;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CostSheetLine)) {
            return false;
        }
        CostSheetLine other = (CostSheetLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("bomLevel", (Object)this.getBomLevel()).add("consumptionQty", (Object)this.getConsumptionQty()).add("costPrice", (Object)this.getCostPrice()).add("typeSelect", (Object)this.getTypeSelect()).add("code", (Object)this.getCode()).add("name", (Object)this.getName()).add("typeSelectIcon", (Object)this.getTypeSelectIcon()).add("unitCostPrice", (Object)this.getUnitCostPrice()).add("ratio", (Object)this.getRatio()).omitNullValues().toString();
    }
}

