/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.production.db.ProdProcessLine;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="PRODUCTION_PROD_PROCESS", indexes={@Index(columnList="name"), @Index(columnList="code"), @Index(columnList="company"), @Index(columnList="fullName"), @Index(columnList="stock_location"), @Index(columnList="produced_product_stock_location"), @Index(columnList="product"), @Index(columnList="workshop_stock_location"), @Index(columnList="original_prod_process")})
@Track(fields={@TrackField(name="name"), @TrackField(name="code"), @TrackField(name="outsourcing"), @TrackField(name="company"), @TrackField(name="fullName"), @TrackField(name="statusSelect"), @TrackField(name="isConsProOnOperation"), @TrackField(name="stockLocation"), @TrackField(name="producedProductStockLocation"), @TrackField(name="product"), @TrackField(name="workshopStockLocation"), @TrackField(name="versionNumber"), @TrackField(name="originalProdProcess"), @TrackField(name="isEnabledForAllProducts"), @TrackField(name="launchQty"), @TrackField(name="stockMoveRealizeOrderSelect")})
public class ProdProcess
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PRODUCTION_PROD_PROCESS_SEQ")
    @SequenceGenerator(name="PRODUCTION_PROD_PROCESS_SEQ", sequenceName="PRODUCTION_PROD_PROCESS_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Phases")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="prodProcess", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="priority")
    private List<ProdProcessLine> prodProcessLineList;
    @Widget(title="Label", massUpdate=true)
    @NotNull
    private String name;
    @Widget(title="Code")
    private String code;
    @Widget(title="Outsourcing")
    private Boolean outsourcing = Boolean.FALSE;
    @Widget(title="Company")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Label")
    @NameColumn
    private String fullName;
    @Widget(title="Status", readonly=true, selection="production.prod.process.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Manage consumed products on phases")
    private Boolean isConsProOnOperation = Boolean.FALSE;
    @Widget(title="Production stock location", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation stockLocation;
    @Widget(title="Stock location for produced product", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation producedProductStockLocation;
    @Widget(title="Product")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Workshop", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation workshopStockLocation;
    @Widget(title="Version number")
    private Integer versionNumber = 1;
    @Widget(title="Original production process")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProdProcess originalProdProcess;
    @Widget(title="Enable the process for other products")
    private Boolean isEnabledForAllProducts = Boolean.FALSE;
    @Widget(title="Launch quantity")
    private BigDecimal launchQty = BigDecimal.ZERO;
    @Widget(selection="production.manuf.order.stock.move.realize.order.select", massUpdate=true)
    private Integer stockMoveRealizeOrderSelect = 1;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ProdProcess() {
    }

    public ProdProcess(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<ProdProcessLine> getProdProcessLineList() {
        return this.prodProcessLineList;
    }

    public void setProdProcessLineList(List<ProdProcessLine> prodProcessLineList) {
        this.prodProcessLineList = prodProcessLineList;
    }

    public void addProdProcessLineListItem(ProdProcessLine item) {
        if (this.getProdProcessLineList() == null) {
            this.setProdProcessLineList(new ArrayList<ProdProcessLine>());
        }
        this.getProdProcessLineList().add(item);
        item.setProdProcess(this);
    }

    public void removeProdProcessLineListItem(ProdProcessLine item) {
        if (this.getProdProcessLineList() == null) {
            return;
        }
        this.getProdProcessLineList().remove((Object)item);
    }

    public void clearProdProcessLineList() {
        if (this.getProdProcessLineList() != null) {
            this.getProdProcessLineList().clear();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Boolean getOutsourcing() {
        return this.outsourcing == null ? Boolean.FALSE : this.outsourcing;
    }

    public void setOutsourcing(Boolean outsourcing) {
        this.outsourcing = outsourcing;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Boolean getIsConsProOnOperation() {
        return this.isConsProOnOperation == null ? Boolean.FALSE : this.isConsProOnOperation;
    }

    public void setIsConsProOnOperation(Boolean isConsProOnOperation) {
        this.isConsProOnOperation = isConsProOnOperation;
    }

    public StockLocation getStockLocation() {
        return this.stockLocation;
    }

    public void setStockLocation(StockLocation stockLocation) {
        this.stockLocation = stockLocation;
    }

    public StockLocation getProducedProductStockLocation() {
        return this.producedProductStockLocation;
    }

    public void setProducedProductStockLocation(StockLocation producedProductStockLocation) {
        this.producedProductStockLocation = producedProductStockLocation;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public StockLocation getWorkshopStockLocation() {
        return this.workshopStockLocation;
    }

    public void setWorkshopStockLocation(StockLocation workshopStockLocation) {
        this.workshopStockLocation = workshopStockLocation;
    }

    public Integer getVersionNumber() {
        return this.versionNumber == null ? 0 : this.versionNumber;
    }

    public void setVersionNumber(Integer versionNumber) {
        this.versionNumber = versionNumber;
    }

    public ProdProcess getOriginalProdProcess() {
        return this.originalProdProcess;
    }

    public void setOriginalProdProcess(ProdProcess originalProdProcess) {
        this.originalProdProcess = originalProdProcess;
    }

    public Boolean getIsEnabledForAllProducts() {
        return this.isEnabledForAllProducts == null ? Boolean.FALSE : this.isEnabledForAllProducts;
    }

    public void setIsEnabledForAllProducts(Boolean isEnabledForAllProducts) {
        this.isEnabledForAllProducts = isEnabledForAllProducts;
    }

    public BigDecimal getLaunchQty() {
        return this.launchQty == null ? BigDecimal.ZERO : this.launchQty;
    }

    public void setLaunchQty(BigDecimal launchQty) {
        this.launchQty = launchQty;
    }

    public Integer getStockMoveRealizeOrderSelect() {
        return this.stockMoveRealizeOrderSelect == null ? 0 : this.stockMoveRealizeOrderSelect;
    }

    public void setStockMoveRealizeOrderSelect(Integer stockMoveRealizeOrderSelect) {
        this.stockMoveRealizeOrderSelect = stockMoveRealizeOrderSelect;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProdProcess)) {
            return false;
        }
        ProdProcess other = (ProdProcess)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("code", (Object)this.getCode()).add("outsourcing", (Object)this.getOutsourcing()).add("fullName", (Object)this.getFullName()).add("statusSelect", (Object)this.getStatusSelect()).add("isConsProOnOperation", (Object)this.getIsConsProOnOperation()).add("versionNumber", (Object)this.getVersionNumber()).add("isEnabledForAllProducts", (Object)this.getIsEnabledForAllProducts()).add("launchQty", (Object)this.getLaunchQty()).add("stockMoveRealizeOrderSelect", (Object)this.getStockMoveRealizeOrderSelect()).omitNullValues().toString();
    }
}

