/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.db;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.production.db.ManufOrder;
import com.axelor.apps.production.db.OperationOrder;
import com.axelor.apps.production.db.ProdProcessLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="PRODUCTION_PROD_PRODUCT", indexes={@Index(columnList="product"), @Index(columnList="unit"), @Index(columnList="to_consume_operation_order"), @Index(columnList="diff_consume_operation_order"), @Index(columnList="to_consume_manuf_order"), @Index(columnList="diff_consume_manuf_order"), @Index(columnList="to_produce_manuf_order"), @Index(columnList="waste_manuf_order"), @Index(columnList="to_consume_prod_process_line")})
public class ProdProduct
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PRODUCTION_PROD_PRODUCT_SEQ")
    @SequenceGenerator(name="PRODUCTION_PROD_PRODUCT_SEQ", sequenceName="PRODUCTION_PROD_PRODUCT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Product")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Qty")
    private BigDecimal qty = BigDecimal.ZERO;
    @Widget(title="Unit")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit unit;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private OperationOrder toConsumeOperationOrder;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private OperationOrder diffConsumeOperationOrder;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ManufOrder toConsumeManufOrder;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ManufOrder diffConsumeManufOrder;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ManufOrder toProduceManufOrder;
    @Widget(title="MO")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ManufOrder wasteManufOrder;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProdProcessLine toConsumeProdProcessLine;
    @Widget(title="Planned Qty")
    private BigDecimal plannedQty = BigDecimal.ZERO;
    @Widget(title="Real Qty")
    private BigDecimal realQty = BigDecimal.ZERO;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ProdProduct() {
    }

    public ProdProduct(Product product, BigDecimal qty, Unit unit) {
        this.product = product;
        this.qty = qty;
        this.unit = unit;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public BigDecimal getQty() {
        return this.qty == null ? BigDecimal.ZERO : this.qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public OperationOrder getToConsumeOperationOrder() {
        return this.toConsumeOperationOrder;
    }

    public void setToConsumeOperationOrder(OperationOrder toConsumeOperationOrder) {
        this.toConsumeOperationOrder = toConsumeOperationOrder;
    }

    public OperationOrder getDiffConsumeOperationOrder() {
        return this.diffConsumeOperationOrder;
    }

    public void setDiffConsumeOperationOrder(OperationOrder diffConsumeOperationOrder) {
        this.diffConsumeOperationOrder = diffConsumeOperationOrder;
    }

    public ManufOrder getToConsumeManufOrder() {
        return this.toConsumeManufOrder;
    }

    public void setToConsumeManufOrder(ManufOrder toConsumeManufOrder) {
        this.toConsumeManufOrder = toConsumeManufOrder;
    }

    public ManufOrder getDiffConsumeManufOrder() {
        return this.diffConsumeManufOrder;
    }

    public void setDiffConsumeManufOrder(ManufOrder diffConsumeManufOrder) {
        this.diffConsumeManufOrder = diffConsumeManufOrder;
    }

    public ManufOrder getToProduceManufOrder() {
        return this.toProduceManufOrder;
    }

    public void setToProduceManufOrder(ManufOrder toProduceManufOrder) {
        this.toProduceManufOrder = toProduceManufOrder;
    }

    public ManufOrder getWasteManufOrder() {
        return this.wasteManufOrder;
    }

    public void setWasteManufOrder(ManufOrder wasteManufOrder) {
        this.wasteManufOrder = wasteManufOrder;
    }

    public ProdProcessLine getToConsumeProdProcessLine() {
        return this.toConsumeProdProcessLine;
    }

    public void setToConsumeProdProcessLine(ProdProcessLine toConsumeProdProcessLine) {
        this.toConsumeProdProcessLine = toConsumeProdProcessLine;
    }

    public BigDecimal getPlannedQty() {
        return this.plannedQty == null ? BigDecimal.ZERO : this.plannedQty;
    }

    public void setPlannedQty(BigDecimal plannedQty) {
        this.plannedQty = plannedQty;
    }

    public BigDecimal getRealQty() {
        return this.realQty == null ? BigDecimal.ZERO : this.realQty;
    }

    public void setRealQty(BigDecimal realQty) {
        this.realQty = realQty;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProdProduct)) {
            return false;
        }
        ProdProduct other = (ProdProduct)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("qty", (Object)this.getQty()).add("plannedQty", (Object)this.getPlannedQty()).add("realQty", (Object)this.getRealQty()).omitNullValues().toString();
    }
}

