/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Sequence;
import com.axelor.apps.message.db.Template;
import com.axelor.apps.production.db.WorkshopSequenceConfigLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="PRODUCTION_PRODUCTION_CONFIG", indexes={@Index(columnList="manuf_order_sequence"), @Index(columnList="finish_mo_message_template"), @Index(columnList="part_finish_mo_message_template")})
@Track(fields={@TrackField(name="company", on={TrackEvent.UPDATE}), @TrackField(name="stockMoveRealizeOrderSelect", on={TrackEvent.UPDATE}), @TrackField(name="manufOrderSequence", on={TrackEvent.UPDATE}), @TrackField(name="finishMoAutomaticEmail", on={TrackEvent.UPDATE}), @TrackField(name="finishMoMessageTemplate", on={TrackEvent.UPDATE}), @TrackField(name="partFinishMoAutomaticEmail", on={TrackEvent.UPDATE}), @TrackField(name="partFinishMoMessageTemplate", on={TrackEvent.UPDATE})})
public class ProductionConfig
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PRODUCTION_PRODUCTION_CONFIG_SEQ")
    @SequenceGenerator(name="PRODUCTION_PRODUCTION_CONFIG_SEQ", sequenceName="PRODUCTION_PRODUCTION_CONFIG_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @Widget(title="Company")
    @NotNull
    @JoinColumn(unique=true)
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(selection="production.manuf.order.stock.move.realize.order.select")
    private Integer stockMoveRealizeOrderSelect = 1;
    @Widget(title="Default sequence")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Sequence manufOrderSequence;
    @Widget(title="Sequence by workshop")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="productionConfig", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<WorkshopSequenceConfigLine> workshopSequenceConfigLineList;
    @Widget(title="Send email when manufacturing order finished")
    private Boolean finishMoAutomaticEmail = Boolean.FALSE;
    @Widget(title="Message template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template finishMoMessageTemplate;
    @Widget(title="Send email when manufacturing order partially finished")
    private Boolean partFinishMoAutomaticEmail = Boolean.FALSE;
    @Widget(title="Message template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template partFinishMoMessageTemplate;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Integer getStockMoveRealizeOrderSelect() {
        return this.stockMoveRealizeOrderSelect == null ? 0 : this.stockMoveRealizeOrderSelect;
    }

    public void setStockMoveRealizeOrderSelect(Integer stockMoveRealizeOrderSelect) {
        this.stockMoveRealizeOrderSelect = stockMoveRealizeOrderSelect;
    }

    public Sequence getManufOrderSequence() {
        return this.manufOrderSequence;
    }

    public void setManufOrderSequence(Sequence manufOrderSequence) {
        this.manufOrderSequence = manufOrderSequence;
    }

    public List<WorkshopSequenceConfigLine> getWorkshopSequenceConfigLineList() {
        return this.workshopSequenceConfigLineList;
    }

    public void setWorkshopSequenceConfigLineList(List<WorkshopSequenceConfigLine> workshopSequenceConfigLineList) {
        this.workshopSequenceConfigLineList = workshopSequenceConfigLineList;
    }

    public void addWorkshopSequenceConfigLineListItem(WorkshopSequenceConfigLine item) {
        if (this.getWorkshopSequenceConfigLineList() == null) {
            this.setWorkshopSequenceConfigLineList(new ArrayList<WorkshopSequenceConfigLine>());
        }
        this.getWorkshopSequenceConfigLineList().add(item);
        item.setProductionConfig(this);
    }

    public void removeWorkshopSequenceConfigLineListItem(WorkshopSequenceConfigLine item) {
        if (this.getWorkshopSequenceConfigLineList() == null) {
            return;
        }
        this.getWorkshopSequenceConfigLineList().remove((Object)item);
    }

    public void clearWorkshopSequenceConfigLineList() {
        if (this.getWorkshopSequenceConfigLineList() != null) {
            this.getWorkshopSequenceConfigLineList().clear();
        }
    }

    public Boolean getFinishMoAutomaticEmail() {
        return this.finishMoAutomaticEmail == null ? Boolean.FALSE : this.finishMoAutomaticEmail;
    }

    public void setFinishMoAutomaticEmail(Boolean finishMoAutomaticEmail) {
        this.finishMoAutomaticEmail = finishMoAutomaticEmail;
    }

    public Template getFinishMoMessageTemplate() {
        return this.finishMoMessageTemplate;
    }

    public void setFinishMoMessageTemplate(Template finishMoMessageTemplate) {
        this.finishMoMessageTemplate = finishMoMessageTemplate;
    }

    public Boolean getPartFinishMoAutomaticEmail() {
        return this.partFinishMoAutomaticEmail == null ? Boolean.FALSE : this.partFinishMoAutomaticEmail;
    }

    public void setPartFinishMoAutomaticEmail(Boolean partFinishMoAutomaticEmail) {
        this.partFinishMoAutomaticEmail = partFinishMoAutomaticEmail;
    }

    public Template getPartFinishMoMessageTemplate() {
        return this.partFinishMoMessageTemplate;
    }

    public void setPartFinishMoMessageTemplate(Template partFinishMoMessageTemplate) {
        this.partFinishMoMessageTemplate = partFinishMoMessageTemplate;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProductionConfig)) {
            return false;
        }
        ProductionConfig other = (ProductionConfig)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals((Object)this.getCompany(), (Object)other.getCompany());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{1943172475, this.getCompany()});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("stockMoveRealizeOrderSelect", (Object)this.getStockMoveRealizeOrderSelect()).add("finishMoAutomaticEmail", (Object)this.getFinishMoAutomaticEmail()).add("partFinishMoAutomaticEmail", (Object)this.getPartFinishMoAutomaticEmail()).omitNullValues().toString();
    }
}

