/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.ProductCategory;
import com.axelor.apps.base.db.ProductFamily;
import com.axelor.apps.production.db.UnitCostCalcLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="PRODUCTION_UNIT_COST_CALCULATION", indexes={@Index(columnList="name")})
@Track(fields={@TrackField(name="unitCostCalcSeq"), @TrackField(name="statusSelect"), @TrackField(name="calculationDate"), @TrackField(name="updateCostDate"), @TrackField(name="name"), @TrackField(name="allBomLevels")})
public class UnitCostCalculation
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PRODUCTION_UNIT_COST_CALCULATION_SEQ")
    @SequenceGenerator(name="PRODUCTION_UNIT_COST_CALCULATION_SEQ", sequenceName="PRODUCTION_UNIT_COST_CALCULATION_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Calculation number")
    private String unitCostCalcSeq;
    @Widget(selection="production.cost.calculations.status.select")
    private Integer statusSelect = 0;
    @Widget(title="Name")
    private String name;
    @Widget(title="Description", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Calculate all BOM levels")
    private Boolean allBomLevels = Boolean.TRUE;
    @Widget(title="Calculation date")
    private LocalDate calculationDate;
    @Widget(title="Update costs date")
    private LocalDate updateCostDate;
    @Widget(title="Companies")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Company> companySet;
    @Widget(title="Product sub-types", selection="product.sub.type.product.select")
    private String productSubTypeSelect;
    @Widget(title="Products")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Product> productSet;
    @Widget(title="Product categories")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<ProductCategory> productCategorySet;
    @Widget(title="Product families")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<ProductFamily> productFamilySet;
    @Widget(title="Results")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="unitCostCalculation", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<UnitCostCalcLine> unitCostCalcLineList;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public UnitCostCalculation() {
    }

    public UnitCostCalculation(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUnitCostCalcSeq() {
        return this.unitCostCalcSeq;
    }

    public void setUnitCostCalcSeq(String unitCostCalcSeq) {
        this.unitCostCalcSeq = unitCostCalcSeq;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getAllBomLevels() {
        return this.allBomLevels == null ? Boolean.FALSE : this.allBomLevels;
    }

    public void setAllBomLevels(Boolean allBomLevels) {
        this.allBomLevels = allBomLevels;
    }

    public LocalDate getCalculationDate() {
        return this.calculationDate;
    }

    public void setCalculationDate(LocalDate calculationDate) {
        this.calculationDate = calculationDate;
    }

    public LocalDate getUpdateCostDate() {
        return this.updateCostDate;
    }

    public void setUpdateCostDate(LocalDate updateCostDate) {
        this.updateCostDate = updateCostDate;
    }

    public Set<Company> getCompanySet() {
        return this.companySet;
    }

    public void setCompanySet(Set<Company> companySet) {
        this.companySet = companySet;
    }

    public void addCompanySetItem(Company item) {
        if (this.getCompanySet() == null) {
            this.setCompanySet(new HashSet<Company>());
        }
        this.getCompanySet().add(item);
    }

    public void removeCompanySetItem(Company item) {
        if (this.getCompanySet() == null) {
            return;
        }
        this.getCompanySet().remove((Object)item);
    }

    public void clearCompanySet() {
        if (this.getCompanySet() != null) {
            this.getCompanySet().clear();
        }
    }

    public String getProductSubTypeSelect() {
        return this.productSubTypeSelect;
    }

    public void setProductSubTypeSelect(String productSubTypeSelect) {
        this.productSubTypeSelect = productSubTypeSelect;
    }

    public Set<Product> getProductSet() {
        return this.productSet;
    }

    public void setProductSet(Set<Product> productSet) {
        this.productSet = productSet;
    }

    public void addProductSetItem(Product item) {
        if (this.getProductSet() == null) {
            this.setProductSet(new HashSet<Product>());
        }
        this.getProductSet().add(item);
    }

    public void removeProductSetItem(Product item) {
        if (this.getProductSet() == null) {
            return;
        }
        this.getProductSet().remove((Object)item);
    }

    public void clearProductSet() {
        if (this.getProductSet() != null) {
            this.getProductSet().clear();
        }
    }

    public Set<ProductCategory> getProductCategorySet() {
        return this.productCategorySet;
    }

    public void setProductCategorySet(Set<ProductCategory> productCategorySet) {
        this.productCategorySet = productCategorySet;
    }

    public void addProductCategorySetItem(ProductCategory item) {
        if (this.getProductCategorySet() == null) {
            this.setProductCategorySet(new HashSet<ProductCategory>());
        }
        this.getProductCategorySet().add(item);
    }

    public void removeProductCategorySetItem(ProductCategory item) {
        if (this.getProductCategorySet() == null) {
            return;
        }
        this.getProductCategorySet().remove(item);
    }

    public void clearProductCategorySet() {
        if (this.getProductCategorySet() != null) {
            this.getProductCategorySet().clear();
        }
    }

    public Set<ProductFamily> getProductFamilySet() {
        return this.productFamilySet;
    }

    public void setProductFamilySet(Set<ProductFamily> productFamilySet) {
        this.productFamilySet = productFamilySet;
    }

    public void addProductFamilySetItem(ProductFamily item) {
        if (this.getProductFamilySet() == null) {
            this.setProductFamilySet(new HashSet<ProductFamily>());
        }
        this.getProductFamilySet().add(item);
    }

    public void removeProductFamilySetItem(ProductFamily item) {
        if (this.getProductFamilySet() == null) {
            return;
        }
        this.getProductFamilySet().remove(item);
    }

    public void clearProductFamilySet() {
        if (this.getProductFamilySet() != null) {
            this.getProductFamilySet().clear();
        }
    }

    public List<UnitCostCalcLine> getUnitCostCalcLineList() {
        return this.unitCostCalcLineList;
    }

    public void setUnitCostCalcLineList(List<UnitCostCalcLine> unitCostCalcLineList) {
        this.unitCostCalcLineList = unitCostCalcLineList;
    }

    public void addUnitCostCalcLineListItem(UnitCostCalcLine item) {
        if (this.getUnitCostCalcLineList() == null) {
            this.setUnitCostCalcLineList(new ArrayList<UnitCostCalcLine>());
        }
        this.getUnitCostCalcLineList().add(item);
        item.setUnitCostCalculation(this);
    }

    public void removeUnitCostCalcLineListItem(UnitCostCalcLine item) {
        if (this.getUnitCostCalcLineList() == null) {
            return;
        }
        this.getUnitCostCalcLineList().remove((Object)item);
    }

    public void clearUnitCostCalcLineList() {
        if (this.getUnitCostCalcLineList() != null) {
            this.getUnitCostCalcLineList().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UnitCostCalculation)) {
            return false;
        }
        UnitCostCalculation other = (UnitCostCalculation)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("unitCostCalcSeq", (Object)this.getUnitCostCalcSeq()).add("statusSelect", (Object)this.getStatusSelect()).add("name", (Object)this.getName()).add("allBomLevels", (Object)this.getAllBomLevels()).add("calculationDate", (Object)this.getCalculationDate()).add("updateCostDate", (Object)this.getUpdateCostDate()).add("productSubTypeSelect", (Object)this.getProductSubTypeSelect()).omitNullValues().toString();
    }
}

