/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.db;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.production.db.CostSheetGroup;
import com.axelor.apps.production.db.Machine;
import com.axelor.apps.production.db.OperationOrder;
import com.axelor.apps.production.db.ProdHumanResource;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="PRODUCTION_WORK_CENTER", indexes={@Index(columnList="name"), @Index(columnList="code"), @Index(columnList="machine"), @Index(columnList="product"), @Index(columnList="parent_work_center"), @Index(columnList="operation_order"), @Index(columnList="cost_sheet_group")})
@Track(fields={@TrackField(name="name"), @TrackField(name="code"), @TrackField(name="machine"), @TrackField(name="workCenterTypeSelect"), @TrackField(name="minCapacityPerCycle"), @TrackField(name="maxCapacityPerCycle"), @TrackField(name="durationPerCycle"), @TrackField(name="isRevaluationAtActualPrices"), @TrackField(name="product"), @TrackField(name="costTypeSelect"), @TrackField(name="costAmount"), @TrackField(name="parentWorkCenter"), @TrackField(name="operationOrder"), @TrackField(name="costSheetGroup")})
public class WorkCenter
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PRODUCTION_WORK_CENTER_SEQ")
    @SequenceGenerator(name="PRODUCTION_WORK_CENTER_SEQ", sequenceName="PRODUCTION_WORK_CENTER_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Label")
    @NotNull
    private String name;
    @Widget(title="Code")
    private String code;
    @Widget(title="Default Machine")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Machine machine;
    @Widget(title="Work center type", selection="iproduction.work.center.type.select")
    private Integer workCenterTypeSelect = 0;
    @Widget(title="Min. capacity / cycle")
    private BigDecimal minCapacityPerCycle = BigDecimal.ZERO;
    @Widget(title="Max. capacity / cycle")
    private BigDecimal maxCapacityPerCycle = BigDecimal.ZERO;
    @Widget(title="Duration / cycle (hh:mm:ss)")
    private Long durationPerCycle = 0L;
    @Widget(title="Revaluation at actual prices")
    private Boolean isRevaluationAtActualPrices = Boolean.FALSE;
    @Widget(title="Product")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Cost type", selection="iproduction.work.center.cost.type.select")
    private Integer costTypeSelect = 0;
    @Widget(title="Cost (W.T.)")
    private BigDecimal costAmount = BigDecimal.ZERO;
    @Widget(title="Human resources")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="workCenter", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ProdHumanResource> prodHumanResourceList;
    @Widget(title="Replacement machines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="parentWorkCenter", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<WorkCenter> workCenterList;
    @Widget(title="Work center")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private WorkCenter parentWorkCenter;
    @Widget(title="Operation order")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private OperationOrder operationOrder;
    @Widget(title="Cost sheet group")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private CostSheetGroup costSheetGroup;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public WorkCenter() {
    }

    public WorkCenter(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Machine getMachine() {
        return this.machine;
    }

    public void setMachine(Machine machine) {
        this.machine = machine;
    }

    public Integer getWorkCenterTypeSelect() {
        return this.workCenterTypeSelect == null ? 0 : this.workCenterTypeSelect;
    }

    public void setWorkCenterTypeSelect(Integer workCenterTypeSelect) {
        this.workCenterTypeSelect = workCenterTypeSelect;
    }

    public BigDecimal getMinCapacityPerCycle() {
        return this.minCapacityPerCycle == null ? BigDecimal.ZERO : this.minCapacityPerCycle;
    }

    public void setMinCapacityPerCycle(BigDecimal minCapacityPerCycle) {
        this.minCapacityPerCycle = minCapacityPerCycle;
    }

    public BigDecimal getMaxCapacityPerCycle() {
        return this.maxCapacityPerCycle == null ? BigDecimal.ZERO : this.maxCapacityPerCycle;
    }

    public void setMaxCapacityPerCycle(BigDecimal maxCapacityPerCycle) {
        this.maxCapacityPerCycle = maxCapacityPerCycle;
    }

    public Long getDurationPerCycle() {
        return this.durationPerCycle == null ? 0L : this.durationPerCycle;
    }

    public void setDurationPerCycle(Long durationPerCycle) {
        this.durationPerCycle = durationPerCycle;
    }

    public Boolean getIsRevaluationAtActualPrices() {
        return this.isRevaluationAtActualPrices == null ? Boolean.FALSE : this.isRevaluationAtActualPrices;
    }

    public void setIsRevaluationAtActualPrices(Boolean isRevaluationAtActualPrices) {
        this.isRevaluationAtActualPrices = isRevaluationAtActualPrices;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public Integer getCostTypeSelect() {
        return this.costTypeSelect == null ? 0 : this.costTypeSelect;
    }

    public void setCostTypeSelect(Integer costTypeSelect) {
        this.costTypeSelect = costTypeSelect;
    }

    public BigDecimal getCostAmount() {
        return this.costAmount == null ? BigDecimal.ZERO : this.costAmount;
    }

    public void setCostAmount(BigDecimal costAmount) {
        this.costAmount = costAmount;
    }

    public List<ProdHumanResource> getProdHumanResourceList() {
        return this.prodHumanResourceList;
    }

    public void setProdHumanResourceList(List<ProdHumanResource> prodHumanResourceList) {
        this.prodHumanResourceList = prodHumanResourceList;
    }

    public void addProdHumanResourceListItem(ProdHumanResource item) {
        if (this.getProdHumanResourceList() == null) {
            this.setProdHumanResourceList(new ArrayList<ProdHumanResource>());
        }
        this.getProdHumanResourceList().add(item);
        item.setWorkCenter(this);
    }

    public void removeProdHumanResourceListItem(ProdHumanResource item) {
        if (this.getProdHumanResourceList() == null) {
            return;
        }
        this.getProdHumanResourceList().remove((Object)item);
    }

    public void clearProdHumanResourceList() {
        if (this.getProdHumanResourceList() != null) {
            this.getProdHumanResourceList().clear();
        }
    }

    public List<WorkCenter> getWorkCenterList() {
        return this.workCenterList;
    }

    public void setWorkCenterList(List<WorkCenter> workCenterList) {
        this.workCenterList = workCenterList;
    }

    public void addWorkCenterListItem(WorkCenter item) {
        if (this.getWorkCenterList() == null) {
            this.setWorkCenterList(new ArrayList<WorkCenter>());
        }
        this.getWorkCenterList().add(item);
        item.setParentWorkCenter(this);
    }

    public void removeWorkCenterListItem(WorkCenter item) {
        if (this.getWorkCenterList() == null) {
            return;
        }
        this.getWorkCenterList().remove((Object)item);
    }

    public void clearWorkCenterList() {
        if (this.getWorkCenterList() != null) {
            this.getWorkCenterList().clear();
        }
    }

    public WorkCenter getParentWorkCenter() {
        return this.parentWorkCenter;
    }

    public void setParentWorkCenter(WorkCenter parentWorkCenter) {
        this.parentWorkCenter = parentWorkCenter;
    }

    public OperationOrder getOperationOrder() {
        return this.operationOrder;
    }

    public void setOperationOrder(OperationOrder operationOrder) {
        this.operationOrder = operationOrder;
    }

    public CostSheetGroup getCostSheetGroup() {
        return this.costSheetGroup;
    }

    public void setCostSheetGroup(CostSheetGroup costSheetGroup) {
        this.costSheetGroup = costSheetGroup;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WorkCenter)) {
            return false;
        }
        WorkCenter other = (WorkCenter)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("code", (Object)this.getCode()).add("workCenterTypeSelect", (Object)this.getWorkCenterTypeSelect()).add("minCapacityPerCycle", (Object)this.getMinCapacityPerCycle()).add("maxCapacityPerCycle", (Object)this.getMaxCapacityPerCycle()).add("durationPerCycle", (Object)this.getDurationPerCycle()).add("isRevaluationAtActualPrices", (Object)this.getIsRevaluationAtActualPrices()).add("costTypeSelect", (Object)this.getCostTypeSelect()).add("costAmount", (Object)this.getCostAmount()).omitNullValues().toString();
    }
}

