/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.db.repo;

import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.production.db.ManufOrder;
import com.axelor.apps.production.db.OperationOrder;
import com.axelor.apps.production.db.repo.ManufOrderRepository;
import com.axelor.apps.production.service.operationorder.OperationOrderService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import javax.persistence.PersistenceException;

public class ManufOrderManagementRepository
extends ManufOrderRepository {
    @Inject
    OperationOrderService operationOrderService;

    public ManufOrder copy(ManufOrder entity, boolean deep) {
        entity.setStatusSelect(1);
        entity.setManufOrderSeq(null);
        entity.setPlannedStartDateT(null);
        entity.setPlannedEndDateT(null);
        entity.setRealStartDateT(null);
        entity.setRealEndDateT(null);
        entity.setInStockMoveList(null);
        entity.setOutStockMoveList(null);
        entity.setWasteStockMove(null);
        entity.setToConsumeProdProductList(null);
        entity.setConsumedStockMoveLineList(null);
        entity.setDiffConsumeProdProductList(null);
        entity.setToProduceProdProductList(null);
        entity.setProducedStockMoveLineList(null);
        entity.setWasteProdProductList(null);
        entity.setOperationOrderList(null);
        entity.setCostSheetList(null);
        entity.setCostPrice(null);
        return (ManufOrder)((Object)super.copy((Model)((Object)entity), deep));
    }

    public ManufOrder save(ManufOrder entity) {
        entity = (ManufOrder)((Object)super.save((Model)((Object)entity)));
        try {
            if (Strings.isNullOrEmpty((String)entity.getManufOrderSeq()) && entity.getStatusSelect() == 1) {
                entity.setManufOrderSeq(((SequenceService)Beans.get(SequenceService.class)).getDraftSequenceNumber((Model)((Object)entity)));
            }
        }
        catch (AxelorException e) {
            throw new PersistenceException((Throwable)e);
        }
        for (OperationOrder operationOrder : entity.getOperationOrderList()) {
            if (operationOrder.getBarCode() != null) continue;
            this.operationOrderService.createBarcode(operationOrder);
        }
        return (ManufOrder)((Object)super.save((Model)((Object)entity)));
    }

    public void remove(ManufOrder entity) {
        Integer status = entity.getStatusSelect();
        if (status == 3 || status == 5 || status == 4) {
            throw new PersistenceException(I18n.get((String)"You can't remove this record"));
        }
        if (status == 6) {
            entity.setArchived(true);
        } else {
            super.remove((Model)((Object)entity));
        }
    }
}

