/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.repo.ProductRepository;
import com.axelor.apps.base.service.ProductService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.production.db.BillOfMaterial;
import com.axelor.apps.production.db.TempBomTree;
import com.axelor.apps.production.db.repo.BillOfMaterialRepository;
import com.axelor.apps.production.db.repo.TempBomTreeRepository;
import com.axelor.apps.production.service.BillOfMaterialService;
import com.axelor.apps.production.service.app.AppProductionService;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BillOfMaterialServiceImpl
implements BillOfMaterialService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Inject
    protected BillOfMaterialRepository billOfMaterialRepo;
    @Inject
    private TempBomTreeRepository tempBomTreeRepo;
    @Inject
    private ProductRepository productRepo;
    private List<Long> processedBom;

    @Override
    public List<BillOfMaterial> getBillOfMaterialSet(Product product) {
        return this.billOfMaterialRepo.all().filter("self.product = ?1", new Object[]{product}).fetch();
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void updateProductCostPrice(BillOfMaterial billOfMaterial) throws AxelorException {
        Product product = billOfMaterial.getProduct();
        if (product.getCostTypeSelect() != 1) {
            throw new AxelorException(4, I18n.get((String)"The product cost cannot be changed because the product cost type is not manual"));
        }
        product.setCostPrice(billOfMaterial.getCostPrice().divide(billOfMaterial.getQty(), ((AppBaseService)Beans.get(AppBaseService.class)).getNbDecimalDigitForUnitPrice(), 4));
        ((ProductService)Beans.get(ProductService.class)).updateSalePrice(product);
        this.billOfMaterialRepo.save((Model)((Object)billOfMaterial));
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public BillOfMaterial customizeBillOfMaterial(SaleOrderLine saleOrderLine) throws AxelorException {
        BillOfMaterial billOfMaterial = saleOrderLine.getBillOfMaterial();
        return this.customizeBillOfMaterial(billOfMaterial);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public BillOfMaterial customizeBillOfMaterial(BillOfMaterial billOfMaterial) throws AxelorException {
        return this.customizeBillOfMaterial(billOfMaterial, 0);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public BillOfMaterial customizeBillOfMaterial(BillOfMaterial billOfMaterial, int depth) throws AxelorException {
        if (depth > 1000) {
            throw new AxelorException(5, I18n.get((String)"Max depth reached when copying BOM."));
        }
        if (billOfMaterial != null) {
            BillOfMaterial personalizedBOM = (BillOfMaterial)((Object)JPA.copy((Model)((Object)billOfMaterial), (boolean)true));
            this.billOfMaterialRepo.save((Model)((Object)personalizedBOM));
            personalizedBOM.setName(personalizedBOM.getName() + " (" + I18n.get((String)"Personalized") + " " + personalizedBOM.getId() + ")");
            personalizedBOM.setPersonalized(true);
            HashSet<BillOfMaterial> personalizedBOMSet = new HashSet<BillOfMaterial>();
            for (BillOfMaterial childBillOfMaterial : billOfMaterial.getBillOfMaterialSet()) {
                personalizedBOMSet.add(this.customizeBillOfMaterial(childBillOfMaterial, depth + 1));
            }
            personalizedBOM.setBillOfMaterialSet(personalizedBOMSet);
            return personalizedBOM;
        }
        return null;
    }

    @Override
    @Transactional
    public BillOfMaterial generateNewVersion(BillOfMaterial billOfMaterial) {
        BillOfMaterial copy = (BillOfMaterial)((Object)this.billOfMaterialRepo.copy((Model)((Object)billOfMaterial), true));
        copy.setOriginalBillOfMaterial(billOfMaterial);
        copy.clearCostSheetList();
        copy.setCostPrice(BigDecimal.ZERO);
        copy.setOriginalBillOfMaterial(billOfMaterial);
        copy.setVersionNumber(this.getLatestBillOfMaterialVersion(billOfMaterial, billOfMaterial.getVersionNumber(), true) + 1);
        return (BillOfMaterial)((Object)this.billOfMaterialRepo.save((Model)((Object)copy)));
    }

    public int getLatestBillOfMaterialVersion(BillOfMaterial billOfMaterial, int latestVersion, boolean deep) {
        BillOfMaterial up = billOfMaterial;
        Long previousId = 0L;
        do {
            List billOfMaterialSet;
            if (!(billOfMaterialSet = this.billOfMaterialRepo.all().filter("self.originalBillOfMaterial = :origin AND self.id != :id").bind("origin", (Object)up).bind("id", (Object)previousId).order("-versionNumber").fetch()).isEmpty()) {
                latestVersion = ((BillOfMaterial)((Object)billOfMaterialSet.get(0))).getVersionNumber() > latestVersion ? ((BillOfMaterial)((Object)billOfMaterialSet.get(0))).getVersionNumber() : latestVersion;
                for (BillOfMaterial billOfMaterialIterator : billOfMaterialSet) {
                    int search = this.getLatestBillOfMaterialVersion(billOfMaterialIterator, latestVersion, false);
                    latestVersion = search > latestVersion ? search : latestVersion;
                }
            }
            previousId = up.getId();
        } while ((up = up.getOriginalBillOfMaterial()) != null && deep);
        return latestVersion;
    }

    @Override
    public String getFileName(BillOfMaterial billOfMaterial) {
        return I18n.get((String)"Bill of Material") + "-" + billOfMaterial.getName() + (billOfMaterial.getVersionNumber() > 1 ? "-V" + billOfMaterial.getVersionNumber() : "");
    }

    @Override
    public String getReportLink(BillOfMaterial billOfMaterial, String name, String language, String format) throws AxelorException {
        return ReportFactory.createReport((String)"BillOfMaterial.rptdesign", (String)(name + "-${date}")).addParam("Locale", (Object)language).addParam("BillOfMaterialId", (Object)billOfMaterial.getId()).addFormat(format).generate().getFileLink();
    }

    @Override
    public TempBomTree generateTree(BillOfMaterial billOfMaterial) {
        this.processedBom = new ArrayList<Long>();
        return this.getBomTree(billOfMaterial, null, null);
    }

    @Transactional
    public TempBomTree getBomTree(BillOfMaterial bom, BillOfMaterial parentBom, TempBomTree parent) {
        TempBomTree bomTree = parentBom == null ? (TempBomTree)((Object)this.tempBomTreeRepo.all().filter("self.bom = ?1 and self.parentBom = null", new Object[]{bom}).fetchOne()) : (TempBomTree)((Object)this.tempBomTreeRepo.all().filter("self.bom = ?1 and self.parentBom = ?2", new Object[]{bom, parentBom}).fetchOne());
        if (bomTree == null) {
            bomTree = new TempBomTree();
        }
        bomTree.setProdProcess(bom.getProdProcess());
        bomTree.setProduct(bom.getProduct());
        bomTree.setQty(bom.getQty());
        bomTree.setUnit(bom.getUnit());
        bomTree.setParentBom(parentBom);
        bomTree.setParent(parent);
        bomTree.setBom(bom);
        bomTree = (TempBomTree)((Object)this.tempBomTreeRepo.save((Model)((Object)bomTree)));
        this.processedBom.add(bom.getId());
        List<Long> validBomIds = this.processChildBom(bom, bomTree);
        validBomIds.add(0L);
        this.removeInvalidTree(validBomIds, bom);
        return bomTree;
    }

    private List<Long> processChildBom(BillOfMaterial bom, TempBomTree bomTree) {
        ArrayList<Long> validBomIds = new ArrayList<Long>();
        for (BillOfMaterial childBom : bom.getBillOfMaterialSet()) {
            if (!this.processedBom.contains(childBom.getId())) {
                this.getBomTree(childBom, bom, bomTree);
            } else {
                this.log.debug("Already processed: {}", (Object)childBom.getId());
            }
            validBomIds.add(childBom.getId());
        }
        return validBomIds;
    }

    @Transactional
    public void removeInvalidTree(List<Long> validBomIds, BillOfMaterial bom) {
        List invalidBomTrees = this.tempBomTreeRepo.all().filter("self.bom.id not in (?1) and self.parentBom = ?2", new Object[]{validBomIds, bom}).fetch();
        this.log.debug("Invalid bom trees: {}", (Object)invalidBomTrees);
        if (!invalidBomTrees.isEmpty()) {
            List childBomTrees = this.tempBomTreeRepo.all().filter("self.parent in (?1)", new Object[]{invalidBomTrees}).fetch();
            for (TempBomTree childBomTree : childBomTrees) {
                childBomTree.setParent(null);
                this.tempBomTreeRepo.save((Model)((Object)childBomTree));
            }
        }
        for (TempBomTree invalidBomTree : invalidBomTrees) {
            this.tempBomTreeRepo.remove((Model)((Object)invalidBomTree));
        }
    }

    @Override
    @Transactional
    public void setBillOfMaterialAsDefault(BillOfMaterial billOfMaterial) {
        billOfMaterial.getProduct().setDefaultBillOfMaterial(billOfMaterial);
    }

    @Override
    public String computeName(BillOfMaterial bom) {
        Integer nbDecimalDigitForBomQty = ((AppProductionService)Beans.get(AppProductionService.class)).getAppProduction().getNbDecimalDigitForBomQty();
        return bom.getProduct().getName() + " - " + bom.getQty().setScale((int)nbDecimalDigitForBomQty, RoundingMode.HALF_EVEN) + " " + bom.getUnit().getName() + " - " + bom.getId();
    }

    @Override
    @Transactional
    public void addRawMaterials(long billOfMaterialId, ArrayList<LinkedHashMap<String, Object>> rawMaterials) {
        if (rawMaterials != null && !rawMaterials.isEmpty()) {
            BillOfMaterial billOfMaterial = (BillOfMaterial)((Object)this.billOfMaterialRepo.find(billOfMaterialId));
            int priority = 0;
            if (billOfMaterial.getBillOfMaterialSet() != null && !billOfMaterial.getBillOfMaterialSet().isEmpty()) {
                priority = (Integer)Collections.max(billOfMaterial.getBillOfMaterialSet().stream().map(it -> it.getPriority()).collect(Collectors.toSet()));
            }
            for (LinkedHashMap<String, Object> rawMaterial : rawMaterials) {
                BillOfMaterial newComponent = this.createBomFromRawMaterial(((Integer)rawMaterial.get("id")).intValue(), priority += 10);
                billOfMaterial.getBillOfMaterialSet().add(newComponent);
            }
        } else {
            return;
        }
    }

    @Transactional
    protected BillOfMaterial createBomFromRawMaterial(long productId, int priority) {
        BillOfMaterial newBom = new BillOfMaterial();
        Product rawMaterial = (Product)((Object)this.productRepo.find(productId));
        newBom.setDefineSubBillOfMaterial(false);
        newBom.setPriority(priority);
        newBom.setProduct(rawMaterial);
        newBom.setQty(new BigDecimal(1));
        newBom.setUnit(rawMaterial.getUnit());
        newBom.setWasteRate(BigDecimal.ZERO);
        newBom.setHasNoManageStock(false);
        this.billOfMaterialRepo.save((Model)((Object)newBom));
        String name = this.computeName(newBom);
        newBom.setName(name);
        newBom.setFullName(name);
        return newBom;
    }
}

