/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.production.db.ManufOrder;
import com.axelor.apps.production.db.OperationOrder;
import com.axelor.apps.production.db.repo.ProductionOrderRepository;
import com.axelor.apps.production.service.app.AppProductionService;
import com.axelor.apps.production.service.manuforder.ManufOrderService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.purchase.service.PurchaseOrderLineService;
import com.axelor.apps.stock.service.StockRulesService;
import com.axelor.apps.supplychain.db.MrpLine;
import com.axelor.apps.supplychain.service.MrpLineServiceImpl;
import com.axelor.apps.supplychain.service.PurchaseOrderServiceSupplychainImpl;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.time.LocalDate;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class MrpLineServiceProductionImpl
extends MrpLineServiceImpl {
    protected ManufOrderService manufOrderService;

    @Inject
    public MrpLineServiceProductionImpl(AppProductionService appProductionService, PurchaseOrderServiceSupplychainImpl purchaseOrderServiceSupplychainImpl, PurchaseOrderLineService purchaseOrderLineService, PurchaseOrderRepository purchaseOrderRepo, ManufOrderService manufOrderService, ProductionOrderRepository productionOrderRepo, StockRulesService stockRulesService) {
        super((AppBaseService)appProductionService, purchaseOrderServiceSupplychainImpl, purchaseOrderLineService, purchaseOrderRepo, stockRulesService);
        this.manufOrderService = manufOrderService;
    }

    public void generateProposal(MrpLine mrpLine, Map<Pair<Partner, LocalDate>, PurchaseOrder> purchaseOrders, Map<Partner, PurchaseOrder> purchaseOrdersPerSupplier, boolean isProposalsPerSupplier) throws AxelorException {
        super.generateProposal(mrpLine, purchaseOrders, purchaseOrdersPerSupplier, isProposalsPerSupplier);
        if (mrpLine.getMrpLineType().getElementSelect() == 8 && ((AppProductionService)Beans.get(AppProductionService.class)).isApp("production")) {
            this.generateManufacturingProposal(mrpLine);
        }
    }

    @Transactional(rollbackOn={Exception.class})
    protected void generateManufacturingProposal(MrpLine mrpLine) throws AxelorException {
        Product product = mrpLine.getProduct();
        ManufOrder manufOrder = this.manufOrderService.generateManufOrder(product, mrpLine.getQty(), 2, false, null, mrpLine.getMaturityDate().atStartOfDay(), null, 1);
        this.linkToOrder(mrpLine, manufOrder);
    }

    protected String computeRelatedName(Model model) {
        if (!((AppProductionService)Beans.get(AppProductionService.class)).isApp("production")) {
            return super.computeRelatedName(model);
        }
        if (model instanceof ManufOrder) {
            return ((ManufOrder)((Object)model)).getManufOrderSeq();
        }
        if (model instanceof OperationOrder) {
            return ((OperationOrder)((Object)model)).getName();
        }
        return super.computeRelatedName(model);
    }

    protected Partner getPartner(Model model) {
        if (!((AppProductionService)Beans.get(AppProductionService.class)).isApp("production")) {
            return super.getPartner(model);
        }
        if (model instanceof ManufOrder) {
            return ((ManufOrder)((Object)model)).getClientPartner();
        }
        if (model instanceof OperationOrder) {
            return ((OperationOrder)((Object)model)).getManufOrder().getClientPartner();
        }
        return super.getPartner(model);
    }
}

