/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service;

import com.axelor.apps.production.db.ProdHumanResource;
import com.axelor.apps.production.db.WorkCenter;
import com.axelor.apps.production.db.repo.ProdProcessLineRepository;
import com.axelor.apps.production.service.ProdProcessLineService;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.collections.CollectionUtils;

public class ProdProcessLineServiceImpl
implements ProdProcessLineService {
    protected ProdProcessLineRepository prodProcessLineRepo;

    @Inject
    public ProdProcessLineServiceImpl(ProdProcessLineRepository prodProcessLineRepo) {
        this.prodProcessLineRepo = prodProcessLineRepo;
    }

    @Override
    public Long getProdProcessLineDurationFromWorkCenter(WorkCenter workCenter) {
        ArrayList<Long> durations = new ArrayList<Long>();
        if (workCenter.getWorkCenterTypeSelect() == 2 || workCenter.getWorkCenterTypeSelect() == 3) {
            durations.add(workCenter.getDurationPerCycle());
        }
        if ((workCenter.getWorkCenterTypeSelect() == 1 || workCenter.getWorkCenterTypeSelect() == 3) && workCenter.getProdHumanResourceList() != null) {
            for (ProdHumanResource prodHumanResource : workCenter.getProdHumanResourceList()) {
                durations.add(prodHumanResource.getDuration());
            }
        }
        return !CollectionUtils.isEmpty(durations) ? (Long)Collections.max(durations) : new Long(0L);
    }

    @Override
    public BigDecimal getProdProcessLineMinCapacityPerCycleFromWorkCenter(WorkCenter workCenter) {
        if (workCenter.getWorkCenterTypeSelect() == 2 || workCenter.getWorkCenterTypeSelect() == 3) {
            return workCenter.getMinCapacityPerCycle();
        }
        return new BigDecimal(1);
    }

    @Override
    public BigDecimal getProdProcessLineMaxCapacityPerCycleFromWorkCenter(WorkCenter workCenter) {
        if (workCenter.getWorkCenterTypeSelect() == 2 || workCenter.getWorkCenterTypeSelect() == 3) {
            return workCenter.getMaxCapacityPerCycle();
        }
        return new BigDecimal(1);
    }
}

