/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.production.db.BillOfMaterial;
import com.axelor.apps.production.db.ProdProcess;
import com.axelor.apps.production.db.ProdProcessLine;
import com.axelor.apps.production.db.ProdProduct;
import com.axelor.apps.production.db.repo.ProdProcessRepository;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class ProdProcessService {
    protected ProdProcessRepository prodProcessRepo;

    @Inject
    public ProdProcessService(ProdProcessRepository prodProcessRepo) {
        this.prodProcessRepo = prodProcessRepo;
    }

    public void validateProdProcess(ProdProcess prodProcess, BillOfMaterial bom) throws AxelorException {
        HashMap<Product, BigDecimal> bomMap = new HashMap<Product, BigDecimal>();
        Set setBoM = (Set)MoreObjects.firstNonNull(bom.getBillOfMaterialSet(), Collections.emptySet());
        for (Object bomIt : setBoM) {
            bomMap.put(((BillOfMaterial)((Object)bomIt)).getProduct(), ((BillOfMaterial)((Object)bomIt)).getQty());
        }
        List listPPL = (List)MoreObjects.firstNonNull(prodProcess.getProdProcessLineList(), Collections.emptyList());
        for (ProdProcessLine prodProcessLine : listPPL) {
            List listPP = (List)MoreObjects.firstNonNull(prodProcessLine.getToConsumeProdProductList(), Collections.emptyList());
            for (ProdProduct prodProduct : listPP) {
                if (!bomMap.containsKey((Object)prodProduct.getProduct())) {
                    throw new AxelorException(4, I18n.get((String)"The product %s is not in the bill of material related to this production process"), new Object[]{prodProduct.getProduct().getName()});
                }
                bomMap.put(prodProduct.getProduct(), ((BigDecimal)bomMap.get((Object)prodProduct.getProduct())).subtract(prodProduct.getQty()));
            }
        }
        Set keyList = bomMap.keySet();
        HashMap copyMap = new HashMap();
        ArrayList<String> nameProductList = new ArrayList<String>();
        for (Product product : keyList) {
            if (((BigDecimal)bomMap.get((Object)product)).compareTo(BigDecimal.ZERO) <= 0) continue;
            copyMap.put(product, bomMap.get((Object)product));
            nameProductList.add(product.getName());
        }
        if (!copyMap.isEmpty()) {
            throw new AxelorException(4, I18n.get((String)"Not enough quantity in products to consume for: %s"), new Object[]{Joiner.on((String)",").join(nameProductList)});
        }
    }

    public ProdProcess changeProdProcessListOutsourcing(ProdProcess prodProcess) {
        for (ProdProcessLine prodProcessLine : prodProcess.getProdProcessLineList()) {
            prodProcessLine.setOutsourcing(prodProcess.getOutsourcing());
        }
        return prodProcess;
    }

    public String getLanguageToPrinting(ProdProcess prodProcess) {
        User user = AuthUtils.getUser();
        String language = "en";
        if (user != null && !Strings.isNullOrEmpty((String)user.getLanguage())) {
            return user.getLanguage();
        }
        if (prodProcess == null) {
            return language;
        }
        Company company = prodProcess.getCompany();
        if (company != null && company.getPartner() != null) {
            language = ReportSettings.getPrintingLocale((Partner)company.getPartner());
        }
        return language;
    }

    @Transactional
    public ProdProcess generateNewVersion(ProdProcess prodProcess) {
        ProdProcess copy = (ProdProcess)((Object)this.prodProcessRepo.copy((Model)((Object)prodProcess), true));
        copy.getProdProcessLineList().forEach(list -> list.setProdProcess(copy));
        copy.setOriginalProdProcess(prodProcess);
        copy.setVersionNumber(this.getLatestProdProcessVersion(prodProcess, prodProcess.getVersionNumber(), true) + 1);
        return (ProdProcess)((Object)this.prodProcessRepo.save((Model)((Object)copy)));
    }

    public int getLatestProdProcessVersion(ProdProcess prodProcess, int latestVersion, boolean deep) {
        List prodProcessSet = Lists.newArrayList();
        ProdProcess up = prodProcess;
        Long previousId = 0L;
        do {
            if (!(prodProcessSet = this.prodProcessRepo.all().filter("self.originalProdProcess = :origin AND self.id != :id").bind("origin", (Object)up).bind("id", (Object)previousId).order("-versionNumber").fetch()).isEmpty()) {
                latestVersion = ((ProdProcess)((Object)prodProcessSet.get(0))).getVersionNumber() > latestVersion ? ((ProdProcess)((Object)prodProcessSet.get(0))).getVersionNumber() : latestVersion;
                for (ProdProcess prodProcessIterator : prodProcessSet) {
                    int search = this.getLatestProdProcessVersion(prodProcessIterator, latestVersion, false);
                    latestVersion = search > latestVersion ? search : latestVersion;
                }
            }
            previousId = up.getId();
        } while ((up = up.getOriginalProdProcess()) != null && deep);
        return latestVersion;
    }
}

