/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service;

import com.axelor.apps.production.db.repo.ProdProductRepository;
import com.axelor.apps.production.service.app.AppProductionService;
import com.axelor.db.JPA;
import com.axelor.inject.Beans;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProdProductProductionRepository
extends ProdProductRepository {
    public Map<String, Object> populate(Map<String, Object> json, Map<String, Object> context) {
        if (!((AppProductionService)Beans.get(AppProductionService.class)).isApp("production")) {
            return super.populate(json, context);
        }
        Object productFromView = json.get("product");
        Object qtyFromView = json.get("qty");
        Object toProduceManufOrderIdFromView = context == null || context.isEmpty() ? (json.get("toConsumeManufOrder") == null ? null : ((HashMap)json.get("toConsumeManufOrder")).get("id")) : context.get("id");
        if (productFromView == null || qtyFromView == null || toProduceManufOrderIdFromView == null) {
            return super.populate(json, context);
        }
        Long productId = (Long)((HashMap)productFromView).get("id");
        Long toProduceManufOrderId = (Long)toProduceManufOrderIdFromView;
        json.put("$missingQty", this.computeMissingQty(productId, (BigDecimal)qtyFromView, toProduceManufOrderId));
        return super.populate(json, context);
    }

    protected BigDecimal computeMissingQty(Long productId, BigDecimal qty, Long toProduceManufOrderId) {
        if (productId == null || qty == null || toProduceManufOrderId == null) {
            return BigDecimal.ZERO;
        }
        List queryResult = JPA.em().createQuery("SELECT locationLine.currentQty FROM ManufOrder manufOrder LEFT JOIN StockLocationLine locationLine ON locationLine.stockLocation.id = manufOrder.prodProcess.stockLocation.id WHERE locationLine.product.id = :productId AND manufOrder.id = :manufOrderId", BigDecimal.class).setParameter("productId", (Object)productId).setParameter("manufOrderId", (Object)toProduceManufOrderId).getResultList();
        BigDecimal availableQty = queryResult.isEmpty() ? BigDecimal.ZERO : (BigDecimal)queryResult.get(0);
        return BigDecimal.ZERO.max(qty.subtract(availableQty));
    }
}

