/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.production.db.RawMaterialRequirement;
import com.axelor.apps.production.service.RawMaterialRequirementService;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;

public class RawMaterialRequirementServiceImpl
implements RawMaterialRequirementService {
    public static final String RAW_MATERIAL_REPORT_TITLE = "Raw material requirement";

    @Override
    public String print(RawMaterialRequirement rawMaterialRequirement) throws AxelorException {
        String name = String.format("%s - ${date}", I18n.get((String)RAW_MATERIAL_REPORT_TITLE));
        ReportSettings reportSetting = ReportFactory.createReport((String)"RawMaterialRequirement.rptdesign", (String)name);
        String locale = ReportSettings.getPrintingLocale(null);
        return reportSetting.addParam("RawMaterialRequirementId", (Object)rawMaterialRequirement.getId()).addParam("Locale", (Object)locale).generate().getFileLink();
    }

    @Override
    public String getSequence(RawMaterialRequirement rawMaterialRequirement) throws AxelorException {
        String seq = ((SequenceService)Beans.get(SequenceService.class)).getSequenceNumber("rawMaterialRequirement", rawMaterialRequirement.getCompany());
        if (seq == null) {
            throw new AxelorException(4, I18n.get((String)"Error : You must configure a raw material requirement reporting sequence for the company %s"), new Object[]{rawMaterialRequirement.getCompany().getName()});
        }
        return seq;
    }
}

