/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service.app;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.production.db.BillOfMaterial;
import com.axelor.apps.production.db.ConfiguratorBOM;
import com.axelor.apps.production.service.configurator.ConfiguratorBomService;
import com.axelor.apps.sale.db.Configurator;
import com.axelor.apps.sale.service.configurator.ConfiguratorService;
import com.axelor.apps.sale.service.configurator.ConfiguratorServiceImpl;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.axelor.rpc.JsonContext;
import com.google.inject.persist.Transactional;

public class ConfiguratorServiceProductionImpl
extends ConfiguratorServiceImpl {
    @Transactional(rollbackOn={Exception.class})
    public void generate(Configurator configurator, JsonContext jsonAttributes, JsonContext jsonIndicators) throws AxelorException {
        super.generate(configurator, jsonAttributes, jsonIndicators);
        ConfiguratorBOM configuratorBOM = configurator.getConfiguratorCreator().getConfiguratorBom();
        if (configuratorBOM != null && this.checkConditions(configuratorBOM, jsonAttributes)) {
            Product generatedProduct = configurator.getProduct();
            BillOfMaterial generatedBom = ((ConfiguratorBomService)Beans.get(ConfiguratorBomService.class)).generateBillOfMaterial(configuratorBOM, jsonAttributes, 0, generatedProduct);
            generatedProduct.setDefaultBillOfMaterial(generatedBom);
        }
    }

    protected boolean checkConditions(ConfiguratorBOM configuratorBOM, JsonContext jsonAttributes) throws AxelorException {
        String condition = configuratorBOM.getUseCondition();
        if (condition == null) {
            return true;
        }
        return (Boolean)((ConfiguratorService)Beans.get(ConfiguratorService.class)).computeFormula(condition, jsonAttributes);
    }
}

