/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service.batch;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.service.administration.AbstractBatch;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.production.db.ManufOrder;
import com.axelor.apps.production.db.ProductionBatch;
import com.axelor.apps.production.db.repo.ManufOrderRepository;
import com.axelor.apps.production.service.costsheet.CostSheetService;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.db.JPA;
import com.axelor.db.Query;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;

public class BatchComputeWorkInProgressValuation
extends AbstractBatch {
    protected CostSheetService costSheetService;
    protected ManufOrderRepository manufOrderRepository;
    protected static final int FETCH_LIMIT = 1;

    @Inject
    public BatchComputeWorkInProgressValuation(CostSheetService costSheetService, ManufOrderRepository manufOrderRepository) {
        this.costSheetService = costSheetService;
        this.manufOrderRepository = manufOrderRepository;
    }

    protected void process() {
        ProductionBatch productionBatch = this.batch.getProductionBatch();
        Company company = productionBatch.getCompany();
        StockLocation workshopStockLocation = productionBatch.getWorkshopStockLocation();
        if (productionBatch.getValuationDate() == null) {
            productionBatch.setValuationDate(((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate());
        }
        LocalDate valuationDate = productionBatch.getValuationDate();
        List manufOrderList = null;
        HashMap<String, Number> bindValues = new HashMap<String, Number>();
        String domain = "(self.statusSelect = :statusSelectInProgress or self.statusSelect = :statusSelectStandBy)";
        bindValues.put("statusSelectInProgress", 4);
        bindValues.put("statusSelectStandBy", 5);
        if (company != null && workshopStockLocation == null) {
            domain = domain + " and self.company.id = :companyId";
            bindValues.put("companyId", company.getId());
        } else if (company == null && workshopStockLocation != null) {
            domain = domain + " and self.workshopStockLocation.id = :stockLocationId";
            bindValues.put("stockLocationId", workshopStockLocation.getId());
        } else if (company != null && workshopStockLocation != null) {
            domain = domain + " and (self.company.id = :companyId and self.workshopStockLocation.id = :stockLocationId)";
            bindValues.put("companyId", company.getId());
            bindValues.put("stockLocationId", workshopStockLocation.getId());
        }
        Query manufOrderQuery = ((ManufOrderRepository)((Object)Beans.get(ManufOrderRepository.class))).all().filter(domain).bind(bindValues);
        int offset = 0;
        while (!(manufOrderList = manufOrderQuery.order("id").fetch(1, offset)).isEmpty()) {
            for (ManufOrder manufOrder : manufOrderList) {
                ++offset;
                try {
                    this.costSheetService.computeCostPrice((ManufOrder)((Object)this.manufOrderRepository.find(manufOrder.getId())), 3, valuationDate);
                    this.incrementDone();
                    JPA.clear();
                }
                catch (Exception e) {
                    this.incrementAnomaly();
                    TraceBackService.trace((Throwable)e, (String)"Cannot add a manufacturing order without a production process. Please check that your chosen bill of material has a valid production process.", (long)this.batch.getId());
                }
            }
        }
    }

    protected void stop() {
        String comment = String.format("\t* %s " + I18n.get((String)"Computed work in progress valuation") + "\n", this.batch.getDone());
        comment = comment + String.format("\t" + I18n.get((String)"* %s anomaly(ies)"), this.batch.getAnomaly());
        this.addComment(comment);
        super.stop();
    }
}

