/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service.config;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Sequence;
import com.axelor.apps.production.db.ProductionConfig;
import com.axelor.apps.production.db.WorkshopSequenceConfigLine;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;

public class ProductionConfigService {
    public ProductionConfig getProductionConfig(Company company) throws AxelorException {
        ProductionConfig productionConfig = company.getProductionConfig();
        if (productionConfig == null) {
            throw new AxelorException((Model)((Object)company), 4, I18n.get((String)"You must configure a production for company %s"), new Object[]{company.getName()});
        }
        return productionConfig;
    }

    public Sequence getManufOrderSequence(ProductionConfig productionConfig, StockLocation workshop) throws AxelorException {
        Sequence sequence = null;
        if (productionConfig.getWorkshopSequenceConfigLineList() != null) {
            sequence = productionConfig.getWorkshopSequenceConfigLineList().stream().filter(workshopSequenceConfigLine -> workshopSequenceConfigLine.getWorkshopStockLocation().equals((Object)workshop)).map(WorkshopSequenceConfigLine::getSequence).findFirst().orElseGet(productionConfig::getManufOrderSequence);
        }
        if (sequence == null) {
            throw new AxelorException((Model)((Object)productionConfig), 4, I18n.get((String)"You must configure a sequence for manufacturing order for company %s"), new Object[]{productionConfig.getCompany().getName()});
        }
        return sequence;
    }
}

