/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service.configurator;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.db.repo.ProductRepository;
import com.axelor.apps.base.db.repo.UnitRepository;
import com.axelor.apps.production.db.BillOfMaterial;
import com.axelor.apps.production.db.ConfiguratorBOM;
import com.axelor.apps.production.db.ProdProcess;
import com.axelor.apps.production.db.repo.BillOfMaterialRepository;
import com.axelor.apps.production.db.repo.ConfiguratorBOMRepository;
import com.axelor.apps.production.db.repo.ProdProcessRepository;
import com.axelor.apps.production.service.configurator.ConfiguratorBomService;
import com.axelor.apps.production.service.configurator.ConfiguratorProdProcessService;
import com.axelor.apps.sale.service.configurator.ConfiguratorService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.rpc.JsonContext;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;

public class ConfiguratorBomServiceImpl
implements ConfiguratorBomService {
    private static final int MAX_LEVEL = 10;
    protected ConfiguratorBOMRepository configuratorBOMRepo;
    protected ConfiguratorService configuratorService;
    protected BillOfMaterialRepository billOfMaterialRepository;
    protected ConfiguratorProdProcessService confProdProcessService;

    @Inject
    ConfiguratorBomServiceImpl(ConfiguratorBOMRepository configuratorBOMRepo, ConfiguratorService configuratorService, BillOfMaterialRepository billOfMaterialRepository, ConfiguratorProdProcessService confProdProcessService) {
        this.configuratorBOMRepo = configuratorBOMRepo;
        this.configuratorService = configuratorService;
        this.billOfMaterialRepository = billOfMaterialRepository;
        this.confProdProcessService = confProdProcessService;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public BillOfMaterial generateBillOfMaterial(ConfiguratorBOM configuratorBOM, JsonContext attributes, int level, Product generatedProduct) throws AxelorException {
        ProdProcess prodProcess;
        Unit unit;
        Product product;
        if (++level > 10) {
            throw new AxelorException(4, I18n.get((String)"Too many recursive calls to create the bill of material."));
        }
        String name = configuratorBOM.getDefNameAsFormula() != false ? (String)this.configuratorService.computeFormula(configuratorBOM.getNameFormula(), attributes) : configuratorBOM.getName();
        if (configuratorBOM.getDefProductFromConfigurator().booleanValue()) {
            product = generatedProduct;
        } else if (configuratorBOM.getDefProductAsFormula().booleanValue()) {
            product = (Product)((Object)this.configuratorService.computeFormula(configuratorBOM.getProductFormula(), attributes));
            if (product != null) {
                product = (Product)((Object)((ProductRepository)((Object)Beans.get(ProductRepository.class))).find(product.getId()));
            }
        } else {
            product = configuratorBOM.getProduct();
        }
        BigDecimal qty = configuratorBOM.getDefQtyAsFormula() != false ? new BigDecimal(this.configuratorService.computeFormula(configuratorBOM.getQtyFormula(), attributes).toString()) : configuratorBOM.getQty();
        if (configuratorBOM.getDefUnitAsFormula().booleanValue()) {
            unit = (Unit)this.configuratorService.computeFormula(configuratorBOM.getUnitFormula(), attributes);
            if (unit != null) {
                unit = (Unit)((UnitRepository)Beans.get(UnitRepository.class)).find(unit.getId());
            }
        } else {
            unit = configuratorBOM.getUnit();
        }
        if (configuratorBOM.getDefProdProcessAsFormula().booleanValue()) {
            prodProcess = (ProdProcess)((Object)this.configuratorService.computeFormula(configuratorBOM.getProdProcessFormula(), attributes));
            if (prodProcess != null) {
                prodProcess = (ProdProcess)((Object)((ProdProcessRepository)((Object)Beans.get(ProdProcessRepository.class))).find(prodProcess.getId()));
            }
        } else {
            prodProcess = configuratorBOM.getDefProdProcessAsConfigurator() != false ? this.confProdProcessService.generateProdProcessService(configuratorBOM.getConfiguratorProdProcess(), attributes, product) : configuratorBOM.getProdProcess();
        }
        BillOfMaterial billOfMaterial = new BillOfMaterial();
        billOfMaterial.setCompany(configuratorBOM.getCompany());
        billOfMaterial.setName(name);
        billOfMaterial.setProduct(product);
        billOfMaterial.setQty(qty);
        billOfMaterial.setUnit(unit);
        billOfMaterial.setProdProcess(prodProcess);
        billOfMaterial.setStatusSelect(configuratorBOM.getStatusSelect());
        if (configuratorBOM.getConfiguratorBomList() != null) {
            for (ConfiguratorBOM confBomChild : configuratorBOM.getConfiguratorBomList()) {
                BillOfMaterial childBom = this.generateBillOfMaterial(confBomChild, attributes, level, generatedProduct);
                billOfMaterial.addBillOfMaterialSetItem(childBom);
            }
        }
        billOfMaterial = (BillOfMaterial)((Object)this.billOfMaterialRepository.save((Model)((Object)billOfMaterial)));
        configuratorBOM.setBillOfMaterialId(billOfMaterial.getId());
        this.configuratorBOMRepo.save((Model)((Object)configuratorBOM));
        return billOfMaterial;
    }
}

