/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service.configurator;

import com.axelor.apps.production.db.ConfiguratorProdProcessLine;
import com.axelor.apps.production.db.ProdProcessLine;
import com.axelor.apps.production.service.configurator.ConfiguratorProdProcessLineService;
import com.axelor.apps.sale.service.configurator.ConfiguratorService;
import com.axelor.exception.AxelorException;
import com.axelor.rpc.JsonContext;
import com.google.inject.Inject;
import java.math.BigDecimal;

public class ConfiguratorProdProcessLineServiceImpl
implements ConfiguratorProdProcessLineService {
    protected ConfiguratorService configuratorService;

    @Inject
    ConfiguratorProdProcessLineServiceImpl(ConfiguratorService configuratorService) {
        this.configuratorService = configuratorService;
    }

    @Override
    public ProdProcessLine generateProdProcessLine(ConfiguratorProdProcessLine confProdProcessLine, JsonContext attributes) throws AxelorException {
        if (confProdProcessLine == null) {
            return null;
        }
        ProdProcessLine prodProcessLine = new ProdProcessLine();
        BigDecimal minCapacityPerCycle = confProdProcessLine.getDefMinCapacityFormula() != false ? new BigDecimal(this.configuratorService.computeFormula(confProdProcessLine.getMinCapacityPerCycleFormula(), attributes).toString()) : confProdProcessLine.getMinCapacityPerCycle();
        BigDecimal maxCapacityPerCycle = confProdProcessLine.getDefMaxCapacityFormula() != false ? new BigDecimal(this.configuratorService.computeFormula(confProdProcessLine.getMaxCapacityPerCycleFormula(), attributes).toString()) : confProdProcessLine.getMaxCapacityPerCycle();
        long durationPerCycle = confProdProcessLine.getDefDurationFormula() != false ? Long.decode(this.configuratorService.computeFormula(confProdProcessLine.getDurationPerCycleFormula(), attributes).toString()).longValue() : confProdProcessLine.getDurationPerCycle().longValue();
        prodProcessLine.setName(confProdProcessLine.getName());
        prodProcessLine.setPriority(confProdProcessLine.getPriority());
        prodProcessLine.setWorkCenter(confProdProcessLine.getWorkCenter());
        prodProcessLine.setOutsourcing(confProdProcessLine.getOutsourcing());
        prodProcessLine.setStockLocation(confProdProcessLine.getStockLocation());
        prodProcessLine.setDescription(confProdProcessLine.getDescription());
        prodProcessLine.setMinCapacityPerCycle(minCapacityPerCycle);
        prodProcessLine.setMaxCapacityPerCycle(maxCapacityPerCycle);
        prodProcessLine.setDurationPerCycle(durationPerCycle);
        return prodProcessLine;
    }
}

