/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service.costsheet;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.db.repo.UnitRepository;
import com.axelor.apps.base.service.CurrencyService;
import com.axelor.apps.base.service.ShippingCoefService;
import com.axelor.apps.base.service.UnitConversionService;
import com.axelor.apps.production.db.BillOfMaterial;
import com.axelor.apps.production.db.CostSheetGroup;
import com.axelor.apps.production.db.CostSheetLine;
import com.axelor.apps.production.db.ProdHumanResource;
import com.axelor.apps.production.db.UnitCostCalcLine;
import com.axelor.apps.production.db.UnitCostCalculation;
import com.axelor.apps.production.db.WorkCenter;
import com.axelor.apps.production.db.repo.CostSheetGroupRepository;
import com.axelor.apps.production.service.app.AppProductionService;
import com.axelor.apps.production.service.costsheet.CostSheetLineService;
import com.axelor.apps.production.service.costsheet.UnitCostCalcLineServiceImpl;
import com.axelor.apps.purchase.db.SupplierCatalog;
import com.axelor.apps.stock.service.WeightedAveragePriceService;
import com.axelor.exception.AxelorException;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CostSheetLineServiceImpl
implements CostSheetLineService {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected AppProductionService appProductionService;
    protected CostSheetGroupRepository costSheetGroupRepository;
    protected UnitConversionService unitConversionService;
    protected UnitRepository unitRepo;
    protected WeightedAveragePriceService weightedAveragePriceService;
    protected UnitCostCalcLineServiceImpl unitCostCalcLineServiceImpl;
    protected CurrencyService currencyService;
    protected ShippingCoefService shippingCoefService;

    @Inject
    public CostSheetLineServiceImpl(AppProductionService appProductionService, CostSheetGroupRepository costSheetGroupRepository, UnitConversionService unitConversionService, UnitRepository unitRepo, WeightedAveragePriceService weightedAveragePriceService, UnitCostCalcLineServiceImpl unitCostCalcLineServiceImpl, CurrencyService currencyService, ShippingCoefService shippingCoefService) {
        this.appProductionService = appProductionService;
        this.costSheetGroupRepository = costSheetGroupRepository;
        this.unitConversionService = unitConversionService;
        this.unitRepo = unitRepo;
        this.weightedAveragePriceService = weightedAveragePriceService;
        this.unitCostCalcLineServiceImpl = unitCostCalcLineServiceImpl;
        this.currencyService = currencyService;
        this.shippingCoefService = shippingCoefService;
    }

    @Override
    public CostSheetLine createCostSheetLine(String name, String code, int bomLevel, BigDecimal consumptionQty, BigDecimal costPrice, CostSheetGroup costSheetGroup, Product product, int typeSelect, int typeSelectIcon, Unit unit, WorkCenter workCenter, CostSheetLine parentCostSheetLine) {
        this.logger.debug("Add a new line of cost sheet ({} - {} - BOM level {} - cost price : {})", new Object[]{code, name, bomLevel, costPrice});
        CostSheetLine costSheetLine = new CostSheetLine(code, name);
        costSheetLine.setBomLevel(bomLevel);
        costSheetLine.setConsumptionQty(consumptionQty);
        costSheetLine.setCostSheetGroup(costSheetGroup);
        costSheetLine.setProduct(product);
        costSheetLine.setTypeSelect(typeSelect);
        costSheetLine.setTypeSelectIcon(typeSelectIcon);
        if (unit != null) {
            costSheetLine.setUnit((Unit)this.unitRepo.find(unit.getId()));
        }
        costSheetLine.setWorkCenter(workCenter);
        if (costPrice == null) {
            costPrice = BigDecimal.ZERO;
        }
        costSheetLine.setCostPrice(costPrice.setScale(this.appProductionService.getNbDecimalDigitForUnitPrice(), 6));
        if (parentCostSheetLine != null) {
            parentCostSheetLine.addCostSheetLineListItem(costSheetLine);
            this.createIndirectCostSheetGroups(costSheetGroup, parentCostSheetLine, costSheetLine.getCostPrice());
        }
        return costSheetLine;
    }

    @Override
    public CostSheetLine createProducedProductCostSheetLine(Product product, Unit unit, BigDecimal consumptionQty) {
        return this.createCostSheetLine(product.getName(), product.getCode(), 0, consumptionQty, null, product.getCostSheetGroup(), product, 1, 1, unit, null, null);
    }

    @Override
    public CostSheetLine createResidualProductCostSheetLine(Product product, Unit unit, BigDecimal consumptionQty) throws AxelorException {
        if (this.appProductionService.getAppProduction().getSubtractProdResidualOnCostSheet().booleanValue()) {
            consumptionQty = consumptionQty.negate();
        }
        BigDecimal costPrice = this.unitConversionService.convert(unit, product.getUnit(), product.getCostPrice(), this.appProductionService.getNbDecimalDigitForUnitPrice(), product).multiply(consumptionQty);
        return this.createCostSheetLine(product.getName(), product.getCode(), 0, consumptionQty, costPrice, product.getCostSheetGroup(), product, 1, 1, unit, null, null);
    }

    @Override
    public CostSheetLine createConsumedProductCostSheetLine(Company company, Product product, Unit unit, int bomLevel, CostSheetLine parentCostSheetLine, BigDecimal consumptionQty, int origin, UnitCostCalculation unitCostCalculation) throws AxelorException {
        Product parentProduct = parentCostSheetLine.getProduct();
        BigDecimal costPrice = null;
        switch (origin) {
            case 1: {
                costPrice = this.getComponentCostPrice(product, parentProduct.getManufOrderCompValuMethodSelect(), company);
                break;
            }
            case 2: {
                UnitCostCalcLine unitCostCalcLine;
                BillOfMaterial componentDefaultBillOfMaterial = product.getDefaultBillOfMaterial();
                if (componentDefaultBillOfMaterial != null && (unitCostCalcLine = this.unitCostCalcLineServiceImpl.getUnitCostCalcLine(unitCostCalculation, product)) != null) {
                    costPrice = unitCostCalcLine.getComputedCost();
                    break;
                }
            }
            case 0: {
                costPrice = this.getComponentCostPrice(product, parentProduct.getBomCompValuMethodSelect(), company);
                break;
            }
            default: {
                costPrice = BigDecimal.ZERO;
            }
        }
        costPrice = costPrice.multiply(consumptionQty);
        costPrice = this.unitConversionService.convert(unit, product.getUnit(), costPrice, this.appProductionService.getNbDecimalDigitForUnitPrice(), product);
        ArrayList costSheetLineList = parentCostSheetLine.getCostSheetLineList() != null ? parentCostSheetLine.getCostSheetLineList() : new ArrayList();
        for (CostSheetLine costSheetLine : costSheetLineList) {
            if (!product.equals((Object)costSheetLine.getProduct()) || !unit.equals((Object)costSheetLine.getUnit())) continue;
            BigDecimal qty = costSheetLine.getConsumptionQty().add(consumptionQty);
            costSheetLine.setConsumptionQty(qty);
            costSheetLine.setCostPrice(costPrice.add(costSheetLine.getCostPrice()).setScale(this.appProductionService.getNbDecimalDigitForUnitPrice(), 6));
            return costSheetLine;
        }
        return this.createCostSheetLine(product.getName(), product.getCode(), bomLevel, consumptionQty, costPrice, product.getCostSheetGroup(), product, 2, 2, unit, null, parentCostSheetLine);
    }

    protected BigDecimal getComponentCostPrice(Product product, int componentsValuationMethod, Company company) throws AxelorException {
        BigDecimal price = null;
        Currency companyCurrency = company.getCurrency();
        if (componentsValuationMethod == 1) {
            price = this.weightedAveragePriceService.computeAvgPriceForCompany(product, company);
            if (price == null || price.compareTo(BigDecimal.ZERO) == 0) {
                price = product.getCostPrice();
            }
        } else if (componentsValuationMethod == 2 && ((price = product.getCostPrice()) == null || price.compareTo(BigDecimal.ZERO) == 0)) {
            price = this.weightedAveragePriceService.computeAvgPriceForCompany(product, company);
        }
        if (price == null || price.compareTo(BigDecimal.ZERO) == 0) {
            price = product.getPurchasePrice();
            BigDecimal shippingCoef = this.shippingCoefService.getShippingCoef(product, product.getDefaultSupplierPartner(), company, new BigDecimal(9999999));
            price = product.getPurchasePrice().multiply(shippingCoef);
            price = this.currencyService.getAmountCurrencyConvertedAtDate(product.getPurchaseCurrency(), companyCurrency, price, this.appProductionService.getTodayDate());
            if (price == null || price.compareTo(BigDecimal.ZERO) == 0) {
                for (SupplierCatalog supplierCatalog : product.getSupplierCatalogList()) {
                    if (BigDecimal.ZERO.compareTo(supplierCatalog.getPrice()) >= 0) continue;
                    price = supplierCatalog.getPrice();
                    Partner supplierPartner = supplierCatalog.getSupplierPartner();
                    if (supplierPartner == null) break;
                    shippingCoef = this.shippingCoefService.getShippingCoef(product, supplierPartner, company, new BigDecimal(9999999));
                    price = price.multiply(shippingCoef);
                    price = this.currencyService.getAmountCurrencyConvertedAtDate(supplierPartner.getCurrency(), companyCurrency, price, this.appProductionService.getTodayDate());
                    break;
                }
            }
        }
        return price;
    }

    @Override
    public CostSheetLine createConsumedProductWasteCostSheetLine(Company company, Product product, Unit unit, int bomLevel, CostSheetLine parentCostSheetLine, BigDecimal consumptionQty, BigDecimal wasteRate, int origin, UnitCostCalculation unitCostCalculation) throws AxelorException {
        Product parentProduct = parentCostSheetLine.getProduct();
        BigDecimal qty = consumptionQty.multiply(wasteRate).divide(new BigDecimal("100"), this.appProductionService.getNbDecimalDigitForBomQty(), 6);
        BigDecimal costPrice = null;
        switch (origin) {
            case 2: {
                UnitCostCalcLine unitCostCalcLine;
                BillOfMaterial componentDefaultBillOfMaterial = product.getDefaultBillOfMaterial();
                if (componentDefaultBillOfMaterial != null && (unitCostCalcLine = this.unitCostCalcLineServiceImpl.getUnitCostCalcLine(unitCostCalculation, product)) != null) {
                    costPrice = unitCostCalcLine.getComputedCost();
                    break;
                }
            }
            case 0: {
                costPrice = this.getComponentCostPrice(product, parentProduct.getBomCompValuMethodSelect(), company);
                break;
            }
            default: {
                costPrice = BigDecimal.ZERO;
            }
        }
        costPrice = this.unitConversionService.convert(unit, product.getUnit(), costPrice, this.appProductionService.getNbDecimalDigitForUnitPrice(), product).multiply(qty);
        return this.createCostSheetLine(product.getName(), product.getCode(), bomLevel, qty.setScale(this.appProductionService.getNbDecimalDigitForBomQty(), RoundingMode.HALF_EVEN), costPrice.setScale(this.appProductionService.getNbDecimalDigitForUnitPrice(), RoundingMode.HALF_EVEN), product.getCostSheetGroup(), product, 5, 5, unit, null, parentCostSheetLine);
    }

    @Override
    public CostSheetLine createWorkCenterHRCostSheetLine(WorkCenter workCenter, ProdHumanResource prodHumanResource, int priority, int bomLevel, CostSheetLine parentCostSheetLine, BigDecimal consumptionQty, BigDecimal costPrice, Unit unit) {
        return this.createWorkCenterCostSheetLine(workCenter, priority, bomLevel, parentCostSheetLine, consumptionQty, costPrice, unit, null, 6);
    }

    @Override
    public CostSheetLine createWorkCenterMachineCostSheetLine(WorkCenter workCenter, int priority, int bomLevel, CostSheetLine parentCostSheetLine, BigDecimal consumptionQty, BigDecimal costPrice, Unit unit) {
        return this.createWorkCenterCostSheetLine(workCenter, priority, bomLevel, parentCostSheetLine, consumptionQty, costPrice, unit, workCenter.getCostSheetGroup(), 3);
    }

    protected CostSheetLine createWorkCenterCostSheetLine(WorkCenter workCenter, int priority, int bomLevel, CostSheetLine parentCostSheetLine, BigDecimal consumptionQty, BigDecimal costPrice, Unit unit, CostSheetGroup costSheetGroup, int typeSelectIcon) {
        return this.createCostSheetLine(workCenter.getName(), priority + " - " + workCenter.getCode(), bomLevel, consumptionQty, costPrice, costSheetGroup, null, 3, typeSelectIcon, unit, workCenter, parentCostSheetLine);
    }

    protected List<CostSheetGroup> getIndirectCostSheetGroups(CostSheetGroup costSheetGroup) {
        if (costSheetGroup == null) {
            return Lists.newArrayList();
        }
        return this.costSheetGroupRepository.all().filter("?1 member of self.costSheetGroupSet AND self.costTypeSelect = ?2", new Object[]{costSheetGroup, 3}).fetch();
    }

    protected void createIndirectCostSheetGroups(CostSheetGroup costSheetGroup, CostSheetLine parentCostSheetLine, BigDecimal costPrice) {
        if (costSheetGroup == null) {
            return;
        }
        for (CostSheetGroup indirectCostSheetGroup : this.getIndirectCostSheetGroups(costSheetGroup)) {
            this.createIndirectCostSheetLine(parentCostSheetLine, indirectCostSheetGroup, costPrice);
        }
    }

    protected CostSheetLine createIndirectCostSheetLine(CostSheetLine parentCostSheetLine, CostSheetGroup costSheetGroup, BigDecimal costPrice) {
        CostSheetLine indirectCostSheetLine = this.getCostSheetLine(costSheetGroup, parentCostSheetLine);
        if (indirectCostSheetLine == null) {
            indirectCostSheetLine = this.createCostSheetLine(costSheetGroup.getCode(), costSheetGroup.getName(), parentCostSheetLine.getBomLevel() + 1, BigDecimal.ONE, null, costSheetGroup, null, 4, 4, null, null, parentCostSheetLine);
            parentCostSheetLine.addCostSheetLineListItem(indirectCostSheetLine);
        }
        indirectCostSheetLine.setCostPrice(indirectCostSheetLine.getCostPrice().add(this.getIndirectCostPrice(costSheetGroup, costPrice)));
        return indirectCostSheetLine;
    }

    protected BigDecimal getIndirectCostPrice(CostSheetGroup costSheetGroup, BigDecimal costPrice) {
        BigDecimal indirectCostPrice = BigDecimal.ZERO;
        indirectCostPrice = costPrice.multiply(costSheetGroup.getRate()).divide(new BigDecimal("100"), 2, RoundingMode.HALF_EVEN);
        if (costSheetGroup.getRateTypeSelect() == 1) {
            indirectCostPrice = indirectCostPrice.add(costPrice);
        }
        return indirectCostPrice;
    }

    protected CostSheetLine getCostSheetLine(CostSheetGroup indirectCostSheetGroup, CostSheetLine parentCostSheetLine) {
        for (CostSheetLine costSheetLine : parentCostSheetLine.getCostSheetLineList()) {
            CostSheetGroup costSheetGroup = costSheetLine.getCostSheetGroup();
            if (costSheetGroup == null || costSheetGroup.getCostTypeSelect() != 3 || !costSheetGroup.equals((Object)indirectCostSheetGroup)) continue;
            return costSheetLine;
        }
        return null;
    }
}

