/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service.manuforder;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.production.db.BillOfMaterial;
import com.axelor.apps.production.db.ManufOrder;
import com.axelor.apps.production.db.ProdProduct;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.exception.AxelorException;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

public interface ManufOrderService {
    public static final int DEFAULT_PRIORITY = 2;
    public static final int DEFAULT_PRIORITY_INTERVAL = 10;
    public static final boolean IS_TO_INVOICE = false;
    public static final int ORIGIN_TYPE_MRP = 1;
    public static final int ORIGIN_TYPE_SALE_ORDER = 2;
    public static final int ORIGIN_TYPE_OTHER = 3;

    @Transactional(rollbackOn={Exception.class})
    public ManufOrder generateManufOrder(Product var1, BigDecimal var2, int var3, boolean var4, BillOfMaterial var5, LocalDateTime var6, LocalDateTime var7, int var8) throws AxelorException;

    public void createToConsumeProdProductList(ManufOrder var1);

    public BigDecimal computeToConsumeProdProductLineQuantity(BigDecimal var1, BigDecimal var2, BigDecimal var3);

    public void createToProduceProdProductList(ManufOrder var1);

    public ManufOrder createManufOrder(Product var1, BigDecimal var2, int var3, boolean var4, Company var5, BillOfMaterial var6, LocalDateTime var7, LocalDateTime var8) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public void preFillOperations(ManufOrder var1) throws AxelorException;

    public String getManufOrderSeq(ManufOrder var1) throws AxelorException;

    public boolean isManagedConsumedProduct(BillOfMaterial var1);

    public StockMove generateWasteStockMove(ManufOrder var1) throws AxelorException;

    public void updatePlannedQty(ManufOrder var1) throws AxelorException;

    public void updateRealQty(ManufOrder var1, BigDecimal var2) throws AxelorException;

    public ManufOrder updateDiffProdProductList(ManufOrder var1) throws AxelorException;

    public List<ProdProduct> createDiffProdProductList(ManufOrder var1, List<ProdProduct> var2, List<StockMoveLine> var3) throws AxelorException;

    public List<ProdProduct> createDiffProdProductList(List<ProdProduct> var1, List<StockMoveLine> var2) throws AxelorException;

    public void updateConsumedStockMoveFromManufOrder(ManufOrder var1) throws AxelorException;

    public void updateProducedStockMoveFromManufOrder(ManufOrder var1) throws AxelorException;

    public void checkConsumedStockMoveLineList(ManufOrder var1, ManufOrder var2) throws AxelorException;

    public void checkProducedStockMoveLineList(ManufOrder var1, ManufOrder var2) throws AxelorException;

    public void checkRealizedStockMoveLineList(List<StockMoveLine> var1, List<StockMoveLine> var2) throws AxelorException;

    public void updateStockMoveFromManufOrder(List<StockMoveLine> var1, StockMove var2) throws AxelorException;

    public String getConsumeAndMissingQtyForAProduct(Long var1, Long var2, Long var3);

    public String getBuildingQtyForAProduct(Long var1, Long var2, Long var3);
}

