/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service.manuforder;

import com.axelor.apps.base.db.CancelReason;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.service.ProductService;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.message.db.Template;
import com.axelor.apps.message.db.repo.EmailAccountRepository;
import com.axelor.apps.message.service.TemplateMessageService;
import com.axelor.apps.production.db.ManufOrder;
import com.axelor.apps.production.db.OperationOrder;
import com.axelor.apps.production.db.ProductionConfig;
import com.axelor.apps.production.db.repo.ManufOrderRepository;
import com.axelor.apps.production.db.repo.OperationOrderRepository;
import com.axelor.apps.production.db.repo.ProductionConfigRepository;
import com.axelor.apps.production.service.app.AppProductionService;
import com.axelor.apps.production.service.costsheet.CostSheetService;
import com.axelor.apps.production.service.manuforder.ManufOrderService;
import com.axelor.apps.production.service.manuforder.ManufOrderStockMoveService;
import com.axelor.apps.production.service.operationorder.OperationOrderWorkflowService;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class ManufOrderWorkflowService {
    protected OperationOrderWorkflowService operationOrderWorkflowService;
    protected OperationOrderRepository operationOrderRepo;
    protected ManufOrderStockMoveService manufOrderStockMoveService;
    protected ManufOrderRepository manufOrderRepo;
    @Inject
    ProductionConfigRepository productionConfigRepo;

    @Inject
    public ManufOrderWorkflowService(OperationOrderWorkflowService operationOrderWorkflowService, OperationOrderRepository operationOrderRepo, ManufOrderStockMoveService manufOrderStockMoveService, ManufOrderRepository manufOrderRepo) {
        this.operationOrderWorkflowService = operationOrderWorkflowService;
        this.operationOrderRepo = operationOrderRepo;
        this.manufOrderStockMoveService = manufOrderStockMoveService;
        this.manufOrderRepo = manufOrderRepo;
    }

    @Transactional(rollbackOn={Exception.class})
    public ManufOrder plan(ManufOrder manufOrder) throws AxelorException {
        ManufOrderService manufOrderService = (ManufOrderService)Beans.get(ManufOrderService.class);
        if (manufOrder.getBillOfMaterial().getStatusSelect() != 3 && manufOrder.getProdProcess().getStatusSelect() != 3) {
            throw new AxelorException((Model)((Object)manufOrder), 5, I18n.get((String)"Bill of material and production process must be applicable"));
        }
        if (((SequenceService)Beans.get(SequenceService.class)).isEmptyOrDraftSequenceNumber(manufOrder.getManufOrderSeq())) {
            manufOrder.setManufOrderSeq(manufOrderService.getManufOrderSeq(manufOrder));
        }
        if (CollectionUtils.isEmpty(manufOrder.getOperationOrderList())) {
            manufOrderService.preFillOperations(manufOrder);
        }
        if (!manufOrder.getIsConsProOnOperation().booleanValue() && CollectionUtils.isEmpty(manufOrder.getToConsumeProdProductList())) {
            manufOrderService.createToConsumeProdProductList(manufOrder);
        }
        if (CollectionUtils.isEmpty(manufOrder.getToProduceProdProductList())) {
            manufOrderService.createToProduceProdProductList(manufOrder);
        }
        if (manufOrder.getPlannedStartDateT() == null && manufOrder.getPlannedEndDateT() == null) {
            manufOrder.setPlannedStartDateT(((AppProductionService)Beans.get(AppProductionService.class)).getTodayDateTime().toLocalDateTime());
        } else if (manufOrder.getPlannedStartDateT() == null && manufOrder.getPlannedEndDateT() != null) {
            long duration = 0L;
            for (OperationOrder order : manufOrder.getOperationOrderList()) {
                duration += this.operationOrderWorkflowService.computeEntireCycleDuration(order, order.getManufOrder().getQty());
            }
            manufOrder.setPlannedStartDateT(manufOrder.getPlannedEndDateT().minusSeconds(duration));
        }
        for (OperationOrder operationOrder : this.getSortedOperationOrderList(manufOrder)) {
            this.operationOrderWorkflowService.plan(operationOrder);
        }
        if (manufOrder.getPlannedEndDateT() == null) {
            manufOrder.setPlannedEndDateT(this.computePlannedEndDateT(manufOrder));
        }
        if (manufOrder.getBillOfMaterial() != null) {
            manufOrder.setUnit(manufOrder.getBillOfMaterial().getUnit());
        }
        if (!manufOrder.getIsConsProOnOperation().booleanValue()) {
            this.manufOrderStockMoveService.createToConsumeStockMove(manufOrder);
        }
        this.manufOrderStockMoveService.createToProduceStockMove(manufOrder);
        manufOrder.setStatusSelect(3);
        manufOrder.setCancelReason(null);
        manufOrder.setCancelReasonStr(null);
        return (ManufOrder)((Object)this.manufOrderRepo.save((Model)((Object)manufOrder)));
    }

    @Transactional(rollbackOn={Exception.class})
    public void start(ManufOrder manufOrder) throws AxelorException {
        manufOrder.setRealStartDateT(((AppProductionService)Beans.get(AppProductionService.class)).getTodayDateTime().toLocalDateTime());
        int beforeOrAfterConfig = manufOrder.getProdProcess().getStockMoveRealizeOrderSelect();
        if (beforeOrAfterConfig == 0) {
            for (StockMove stockMove : manufOrder.getInStockMoveList()) {
                this.manufOrderStockMoveService.finishStockMove(stockMove);
            }
        }
        manufOrder.setStatusSelect(4);
        this.manufOrderRepo.save((Model)((Object)manufOrder));
    }

    @Transactional
    public void pause(ManufOrder manufOrder) {
        if (manufOrder.getOperationOrderList() != null) {
            for (OperationOrder operationOrder : manufOrder.getOperationOrderList()) {
                if (operationOrder.getStatusSelect() != 4) continue;
                this.operationOrderWorkflowService.pause(operationOrder);
            }
        }
        manufOrder.setStatusSelect(5);
        this.manufOrderRepo.save((Model)((Object)manufOrder));
    }

    @Transactional
    public void resume(ManufOrder manufOrder) {
        if (manufOrder.getOperationOrderList() != null) {
            for (OperationOrder operationOrder : manufOrder.getOperationOrderList()) {
                if (operationOrder.getStatusSelect() != 5) continue;
                this.operationOrderWorkflowService.resume(operationOrder);
            }
        }
        manufOrder.setStatusSelect(4);
        this.manufOrderRepo.save((Model)((Object)manufOrder));
    }

    @Transactional(rollbackOn={Exception.class})
    public boolean finish(ManufOrder manufOrder) throws AxelorException {
        ProductionConfig productionConfig;
        if (manufOrder.getOperationOrderList() != null) {
            for (OperationOrder operationOrder : manufOrder.getOperationOrderList()) {
                if (operationOrder.getStatusSelect() == 6) continue;
                if (operationOrder.getStatusSelect() != 4 && operationOrder.getStatusSelect() != 5) {
                    this.operationOrderWorkflowService.start(operationOrder);
                }
                this.operationOrderWorkflowService.finish(operationOrder);
            }
        }
        ((CostSheetService)Beans.get(CostSheetService.class)).computeCostPrice(manufOrder, 2, ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate());
        Product product = manufOrder.getProduct();
        if (product.getRealOrEstimatedPriceSelect() == 1) {
            product.setLastProductionPrice(manufOrder.getBillOfMaterial().getCostPrice());
        } else if (product.getRealOrEstimatedPriceSelect() == 2) {
            BigDecimal costPrice = this.computeOneUnitProductionPrice(manufOrder);
            if (costPrice.signum() != 0) {
                product.setLastProductionPrice(costPrice);
            }
        } else {
            product.setRealOrEstimatedPriceSelect(1);
            product.setLastProductionPrice(manufOrder.getBillOfMaterial().getCostPrice());
        }
        if (product.getCostTypeSelect() == 4) {
            product.setCostPrice(product.getLastProductionPrice());
            if (product.getAutoUpdateSalePrice().booleanValue()) {
                ((ProductService)Beans.get(ProductService.class)).updateSalePrice(product);
            }
        }
        this.manufOrderStockMoveService.finish(manufOrder);
        manufOrder.setRealEndDateT(((AppProductionService)Beans.get(AppProductionService.class)).getTodayDateTime().toLocalDateTime());
        manufOrder.setStatusSelect(6);
        manufOrder.setEndTimeDifference(new BigDecimal(ChronoUnit.MINUTES.between(manufOrder.getPlannedEndDateT(), manufOrder.getRealEndDateT())));
        this.manufOrderRepo.save((Model)((Object)manufOrder));
        ProductionConfig productionConfig2 = productionConfig = manufOrder.getCompany() != null ? this.productionConfigRepo.findByCompany(manufOrder.getCompany()) : null;
        if (productionConfig != null && productionConfig.getFinishMoAutomaticEmail().booleanValue()) {
            return this.sendMail(manufOrder, productionConfig.getFinishMoMessageTemplate());
        }
        return true;
    }

    protected BigDecimal computeOneUnitProductionPrice(ManufOrder manufOrder) {
        BigDecimal qty = manufOrder.getQty();
        if (qty.signum() != 0) {
            int scale = ((AppProductionService)Beans.get(AppProductionService.class)).getNbDecimalDigitForUnitPrice();
            return manufOrder.getCostPrice().divide(qty, scale, 6);
        }
        return BigDecimal.ZERO;
    }

    @Transactional(rollbackOn={Exception.class})
    public boolean partialFinish(ManufOrder manufOrder) throws AxelorException {
        ProductionConfig productionConfig;
        if (manufOrder.getIsConsProOnOperation().booleanValue()) {
            for (OperationOrder operationOrder : manufOrder.getOperationOrderList()) {
                if (operationOrder.getStatusSelect() != 3) continue;
                this.operationOrderWorkflowService.start(operationOrder);
            }
        }
        ((CostSheetService)Beans.get(CostSheetService.class)).computeCostPrice(manufOrder, 1, ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate());
        ((ManufOrderStockMoveService)Beans.get(ManufOrderStockMoveService.class)).partialFinish(manufOrder);
        ProductionConfig productionConfig2 = productionConfig = manufOrder.getCompany() != null ? this.productionConfigRepo.findByCompany(manufOrder.getCompany()) : null;
        if (productionConfig != null && productionConfig.getPartFinishMoAutomaticEmail().booleanValue()) {
            return this.sendMail(manufOrder, productionConfig.getPartFinishMoMessageTemplate());
        }
        return true;
    }

    @Transactional(rollbackOn={Exception.class})
    public void cancel(ManufOrder manufOrder, CancelReason cancelReason, String cancelReasonStr) throws AxelorException {
        if (cancelReason == null && manufOrder.getStatusSelect() != 1 && manufOrder.getStatusSelect() != 3) {
            throw new AxelorException(4, I18n.get((String)"A cancel reason must be selected"));
        }
        if (manufOrder.getOperationOrderList() != null) {
            for (OperationOrder operationOrder : manufOrder.getOperationOrderList()) {
                if (operationOrder.getStatusSelect() == 2) continue;
                this.operationOrderWorkflowService.cancel(operationOrder);
            }
        }
        this.manufOrderStockMoveService.cancel(manufOrder);
        if (manufOrder.getConsumedStockMoveLineList() != null) {
            manufOrder.getConsumedStockMoveLineList().forEach(stockMoveLine -> stockMoveLine.setConsumedManufOrder(null));
        }
        if (manufOrder.getProducedStockMoveLineList() != null) {
            manufOrder.getProducedStockMoveLineList().forEach(stockMoveLine -> stockMoveLine.setProducedManufOrder(null));
        }
        if (manufOrder.getDiffConsumeProdProductList() != null) {
            manufOrder.clearDiffConsumeProdProductList();
        }
        manufOrder.setStatusSelect(2);
        if (cancelReason != null) {
            manufOrder.setCancelReason(cancelReason);
            if (Strings.isNullOrEmpty((String)cancelReasonStr)) {
                manufOrder.setCancelReasonStr(cancelReason.getName());
            } else {
                manufOrder.setCancelReasonStr(cancelReasonStr);
            }
        }
        this.manufOrderRepo.save((Model)((Object)manufOrder));
    }

    public LocalDateTime computePlannedEndDateT(ManufOrder manufOrder) {
        OperationOrder lastOperationOrder = this.getLastOperationOrder(manufOrder);
        if (lastOperationOrder != null) {
            return lastOperationOrder.getPlannedEndDateT();
        }
        return manufOrder.getPlannedStartDateT();
    }

    @Transactional(rollbackOn={Exception.class})
    public void allOpFinished(ManufOrder manufOrder) throws AxelorException {
        int count = 0;
        List<OperationOrder> operationOrderList = manufOrder.getOperationOrderList();
        for (OperationOrder operationOrderIt : operationOrderList) {
            if (operationOrderIt.getStatusSelect() != 6) continue;
            ++count;
        }
        if (count == operationOrderList.size()) {
            this.finish(manufOrder);
        }
    }

    public OperationOrder getLastOperationOrder(ManufOrder manufOrder) {
        return (OperationOrder)((Object)this.operationOrderRepo.all().filter("self.manufOrder = ? AND self.plannedEndDateT IS NOT NULL", new Object[]{manufOrder}).order("-plannedEndDateT").fetchOne());
    }

    @Transactional(rollbackOn={Exception.class})
    public void updatePlannedDates(ManufOrder manufOrder, LocalDateTime plannedStartDateT) throws AxelorException {
        manufOrder.setPlannedStartDateT(plannedStartDateT);
        if (manufOrder.getOperationOrderList() != null) {
            List<OperationOrder> operationOrderList = this.getSortedOperationOrderList(manufOrder);
            this.operationOrderWorkflowService.resetPlannedDates(operationOrderList);
            for (OperationOrder operationOrder : operationOrderList) {
                this.operationOrderWorkflowService.replan(operationOrder);
            }
        }
        manufOrder.setPlannedEndDateT(this.computePlannedEndDateT(manufOrder));
    }

    protected List<OperationOrder> getSortedOperationOrderList(ManufOrder manufOrder) {
        List operationOrderList = (List)MoreObjects.firstNonNull(manufOrder.getOperationOrderList(), Collections.emptyList());
        Comparator<OperationOrder> byPriority = Comparator.comparing(OperationOrder::getPriority, Comparator.nullsFirst(Comparator.naturalOrder()));
        Comparator<OperationOrder> byId = Comparator.comparing(OperationOrder::getId, Comparator.nullsFirst(Comparator.naturalOrder()));
        return operationOrderList.stream().sorted(byPriority.thenComparing(byId)).collect(Collectors.toList());
    }

    protected boolean sendMail(ManufOrder manufOrder, Template template) throws AxelorException {
        if (template == null) {
            throw new AxelorException(4, I18n.get((String)"The template to send message for manufacturing order is missing."));
        }
        if (((EmailAccountRepository)((Object)Beans.get(EmailAccountRepository.class))).all().filter("self.isDefault = true AND self.isValid = true").fetchOne() == null) {
            return false;
        }
        try {
            ((TemplateMessageService)Beans.get(TemplateMessageService.class)).generateAndSendMessage((Model)((Object)manufOrder), template);
        }
        catch (Exception e) {
            throw new AxelorException(4, e.getMessage(), new Object[]{manufOrder});
        }
        return true;
    }
}

