/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service.operationorder;

import com.axelor.apps.base.db.DayPlanning;
import com.axelor.apps.base.service.BarcodeGeneratorService;
import com.axelor.apps.base.service.weeklyplanning.WeeklyPlanningService;
import com.axelor.apps.production.db.ManufOrder;
import com.axelor.apps.production.db.OperationOrder;
import com.axelor.apps.production.db.ProdHumanResource;
import com.axelor.apps.production.db.ProdProcessLine;
import com.axelor.apps.production.db.ProdProduct;
import com.axelor.apps.production.db.WorkCenter;
import com.axelor.apps.production.db.repo.OperationOrderRepository;
import com.axelor.apps.production.service.app.AppProductionService;
import com.axelor.apps.production.service.manuforder.ManufOrderService;
import com.axelor.apps.production.service.manuforder.ManufOrderStockMoveService;
import com.axelor.apps.production.service.operationorder.OperationOrderService;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.service.StockMoveService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationOrderServiceImpl
implements OperationOrderService {
    @Inject
    private MetaFiles metaFiles;
    @Inject
    protected BarcodeGeneratorService barcodeGeneratorService;
    @Inject
    protected AppProductionService appProductionService;
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("dd/MM/yyyy");
    private static final DateTimeFormatter DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm");
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    @Transactional(rollbackOn={Exception.class})
    public OperationOrder createOperationOrder(ManufOrder manufOrder, ProdProcessLine prodProcessLine) throws AxelorException {
        OperationOrder operationOrder = this.createOperationOrder(manufOrder, prodProcessLine.getPriority(), prodProcessLine.getWorkCenter(), prodProcessLine.getWorkCenter(), prodProcessLine);
        return (OperationOrder)((Object)((OperationOrderRepository)((Object)Beans.get(OperationOrderRepository.class))).save((Model)((Object)operationOrder)));
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public OperationOrder createOperationOrder(ManufOrder manufOrder, int priority, WorkCenter workCenter, WorkCenter machineWorkCenter, ProdProcessLine prodProcessLine) throws AxelorException {
        this.logger.debug("Cr\u00e9ation d'une op\u00e9ration {} pour l'OF {}", (Object)priority, (Object)manufOrder.getManufOrderSeq());
        String operationName = prodProcessLine.getName();
        OperationOrder operationOrder = new OperationOrder(priority, this.computeName(manufOrder, priority, operationName), operationName, manufOrder, workCenter, machineWorkCenter, 1, prodProcessLine);
        this._createHumanResourceList(operationOrder, machineWorkCenter);
        return (OperationOrder)((Object)((OperationOrderRepository)((Object)Beans.get(OperationOrderRepository.class))).save((Model)((Object)operationOrder)));
    }

    protected void _createHumanResourceList(OperationOrder operationOrder, WorkCenter workCenter) {
        if (workCenter != null && workCenter.getProdHumanResourceList() != null) {
            for (ProdHumanResource prodHumanResource : workCenter.getProdHumanResourceList()) {
                operationOrder.addProdHumanResourceListItem(this.copyProdHumanResource(prodHumanResource));
            }
        }
    }

    protected ProdHumanResource copyProdHumanResource(ProdHumanResource prodHumanResource) {
        return new ProdHumanResource(prodHumanResource.getProduct(), prodHumanResource.getDuration());
    }

    @Override
    public String computeName(ManufOrder manufOrder, int priority, String operationName) {
        String name = "";
        if (manufOrder != null) {
            name = manufOrder.getManufOrderSeq() != null ? name + manufOrder.getManufOrderSeq() : name + manufOrder.getId();
        }
        name = name + "-" + priority + "-" + operationName;
        return name;
    }

    @Override
    public void createToConsumeProdProductList(OperationOrder operationOrder) {
        BigDecimal manufOrderQty = operationOrder.getManufOrder().getQty();
        BigDecimal bomQty = operationOrder.getManufOrder().getBillOfMaterial().getQty();
        ProdProcessLine prodProcessLine = operationOrder.getProdProcessLine();
        if (prodProcessLine.getToConsumeProdProductList() != null) {
            for (ProdProduct prodProduct : prodProcessLine.getToConsumeProdProductList()) {
                BigDecimal qty = ((ManufOrderService)Beans.get(ManufOrderService.class)).computeToConsumeProdProductLineQuantity(bomQty, manufOrderQty, prodProduct.getQty());
                operationOrder.addToConsumeProdProductListItem(new ProdProduct(prodProduct.getProduct(), qty, prodProduct.getUnit()));
            }
        }
    }

    @Override
    public OperationOrder updateDiffProdProductList(OperationOrder operationOrder) throws AxelorException {
        List<ProdProduct> toConsumeList = operationOrder.getToConsumeProdProductList();
        List<StockMoveLine> consumedList = operationOrder.getConsumedStockMoveLineList();
        if (toConsumeList == null || consumedList == null) {
            return operationOrder;
        }
        List<ProdProduct> diffConsumeList = this.createDiffProdProductList(operationOrder, toConsumeList, consumedList);
        operationOrder.clearDiffConsumeProdProductList();
        diffConsumeList.forEach(operationOrder::addDiffConsumeProdProductListItem);
        return operationOrder;
    }

    @Override
    public List<Map<String, Object>> chargeByMachineHours(LocalDateTime fromDateTime, LocalDateTime toDateTime) throws AxelorException {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        LocalDateTime itDateTime = LocalDateTime.parse(fromDateTime.toString(), DateTimeFormatter.ISO_DATE_TIME);
        OperationOrderRepository operationOrderRepo = (OperationOrderRepository)((Object)Beans.get(OperationOrderRepository.class));
        if (Duration.between(fromDateTime, toDateTime).toDays() > 20L) {
            throw new AxelorException(4, I18n.get((String)"Too many days"));
        }
        List operationOrderListTemp = operationOrderRepo.all().filter("self.plannedStartDateT <= ?2 AND self.plannedEndDateT >= ?1", new Object[]{fromDateTime, toDateTime}).fetch();
        HashSet<String> machineNameList = new HashSet<String>();
        for (OperationOrder operationOrder : operationOrderListTemp) {
            if (operationOrder.getWorkCenter() == null || operationOrder.getWorkCenter().getMachine() == null || machineNameList.contains(operationOrder.getWorkCenter().getMachine().getName())) continue;
            machineNameList.add(operationOrder.getWorkCenter().getMachine().getName());
        }
        while (!itDateTime.isAfter(toDateTime)) {
            List operationOrderList = operationOrderRepo.all().filter("self.plannedStartDateT <= ?2 AND self.plannedEndDateT >= ?1", new Object[]{itDateTime, itDateTime.plusHours(1L)}).fetch();
            HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
            for (OperationOrder operationOrder : operationOrderList) {
                if (operationOrder.getWorkCenter() == null || operationOrder.getWorkCenter().getMachine() == null) continue;
                String machine = operationOrder.getWorkCenter().getMachine().getName();
                long numberOfMinutes = 0L;
                numberOfMinutes = operationOrder.getPlannedStartDateT().isBefore(itDateTime) ? Duration.between(itDateTime, operationOrder.getPlannedEndDateT()).toMinutes() : (operationOrder.getPlannedEndDateT().isAfter(itDateTime.plusHours(1L)) ? Duration.between(operationOrder.getPlannedStartDateT(), itDateTime.plusHours(1L)).toMinutes() : Duration.between(operationOrder.getPlannedStartDateT(), operationOrder.getPlannedEndDateT()).toMinutes());
                if (numberOfMinutes > 60L) {
                    numberOfMinutes = 60L;
                }
                BigDecimal percentage = new BigDecimal(numberOfMinutes).multiply(new BigDecimal(100)).divide(new BigDecimal(60), 2, RoundingMode.HALF_UP);
                if (map.containsKey(machine)) {
                    map.put(machine, ((BigDecimal)map.get(machine)).add(percentage));
                    continue;
                }
                map.put(machine, percentage);
            }
            Set keyList = map.keySet();
            for (String key : machineNameList) {
                HashMap<String, Object> dataMap;
                if (keyList.contains(key)) {
                    dataMap = new HashMap<String, Object>();
                    dataMap.put("dateTime", itDateTime.format(DATE_TIME_FORMAT));
                    dataMap.put("charge", map.get(key));
                    dataMap.put("machine", key);
                    dataList.add(dataMap);
                    continue;
                }
                dataMap = new HashMap();
                dataMap.put("dateTime", itDateTime.format(DATE_TIME_FORMAT));
                dataMap.put("charge", BigDecimal.ZERO);
                dataMap.put("machine", key);
                dataList.add(dataMap);
            }
            itDateTime = itDateTime.plusHours(1L);
        }
        return dataList;
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    public List<Map<String, Object>> chargeByMachineDays(LocalDateTime fromDateTime, LocalDateTime toDateTime) throws AxelorException {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        fromDateTime = fromDateTime.withHour(0).withMinute(0);
        toDateTime = toDateTime.withHour(23).withMinute(59);
        LocalDateTime itDateTime = LocalDateTime.parse(fromDateTime.toString(), DateTimeFormatter.ISO_DATE_TIME);
        if (Duration.between(fromDateTime, toDateTime).toDays() > 500L) {
            throw new AxelorException(4, I18n.get((String)"Too many days"));
        }
        List operationOrderListTemp = ((OperationOrderRepository)((Object)Beans.get(OperationOrderRepository.class))).all().filter("self.plannedStartDateT <= ?2 AND self.plannedEndDateT >= ?1", new Object[]{fromDateTime, toDateTime}).fetch();
        HashSet<String> machineNameList = new HashSet<String>();
        for (OperationOrder operationOrder : operationOrderListTemp) {
            if (operationOrder.getWorkCenter() == null || operationOrder.getWorkCenter().getMachine() == null || machineNameList.contains(operationOrder.getWorkCenter().getMachine().getName())) continue;
            machineNameList.add(operationOrder.getWorkCenter().getMachine().getName());
        }
        while (!itDateTime.isAfter(toDateTime)) {
            List operationOrderList = ((OperationOrderRepository)((Object)Beans.get(OperationOrderRepository.class))).all().filter("self.plannedStartDateT <= ?2 AND self.plannedEndDateT >= ?1", new Object[]{itDateTime, itDateTime.plusHours(1L)}).fetch();
            HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
            WeeklyPlanningService weeklyPlanningService = (WeeklyPlanningService)Beans.get(WeeklyPlanningService.class);
            for (OperationOrder operationOrder : operationOrderList) {
                if (operationOrder.getWorkCenter() == null || operationOrder.getWorkCenter().getMachine() == null) continue;
                String machine = operationOrder.getWorkCenter().getMachine().getName();
                long numberOfMinutes = 0L;
                numberOfMinutes = operationOrder.getPlannedStartDateT().isBefore(itDateTime) ? Duration.between(itDateTime, operationOrder.getPlannedEndDateT()).toMinutes() : (operationOrder.getPlannedEndDateT().isAfter(itDateTime.plusHours(1L)) ? Duration.between(operationOrder.getPlannedStartDateT(), itDateTime.plusHours(1L)).toMinutes() : Duration.between(operationOrder.getPlannedStartDateT(), operationOrder.getPlannedEndDateT()).toMinutes());
                if (numberOfMinutes > 60L) {
                    numberOfMinutes = 60L;
                }
                long numberOfMinutesPerDay = 0L;
                if (operationOrder.getWorkCenter().getMachine().getWeeklyPlanning() != null) {
                    DayPlanning dayPlanning = weeklyPlanningService.findDayPlanning(operationOrder.getWorkCenter().getMachine().getWeeklyPlanning(), LocalDateTime.parse(itDateTime.toString(), DateTimeFormatter.ISO_DATE_TIME).toLocalDate());
                    if (dayPlanning != null) {
                        numberOfMinutesPerDay = Duration.between(dayPlanning.getMorningFrom(), dayPlanning.getMorningTo()).toMinutes();
                        numberOfMinutesPerDay += Duration.between(dayPlanning.getAfternoonFrom(), dayPlanning.getAfternoonTo()).toMinutes();
                    } else {
                        numberOfMinutesPerDay = 0L;
                    }
                } else {
                    numberOfMinutesPerDay = 480L;
                }
                if (numberOfMinutesPerDay == 0L) continue;
                BigDecimal percentage = new BigDecimal(numberOfMinutes).multiply(new BigDecimal(100)).divide(new BigDecimal(numberOfMinutesPerDay), 2, RoundingMode.HALF_UP);
                if (map.containsKey(machine)) {
                    map.put(machine, ((BigDecimal)map.get(machine)).add(percentage));
                    continue;
                }
                map.put(machine, percentage);
            }
            Set keyList = map.keySet();
            for (String key : machineNameList) {
                if (!keyList.contains(key)) continue;
                boolean found = false;
                for (Map mapIt : dataList) {
                    if (!mapIt.get("dateTime").equals(itDateTime.format(DATE_FORMAT)) || !mapIt.get("machine").equals(key)) continue;
                    mapIt.put("charge", new BigDecimal(mapIt.get("charge").toString()).add((BigDecimal)map.get(key)));
                    found = true;
                    break;
                }
                if (found) continue;
                HashMap<String, String> dataMap = new HashMap<String, String>();
                dataMap.put("dateTime", itDateTime.format(DATE_FORMAT));
                dataMap.put("charge", (String)map.get(key));
                dataMap.put("machine", key);
                dataList.add(dataMap);
            }
            itDateTime = itDateTime.plusHours(1L);
        }
        return dataList;
    }

    @Override
    public List<ProdProduct> createDiffProdProductList(OperationOrder operationOrder, List<ProdProduct> prodProductList, List<StockMoveLine> stockMoveLineList) throws AxelorException {
        List<ProdProduct> diffConsumeList = ((ManufOrderService)Beans.get(ManufOrderService.class)).createDiffProdProductList(prodProductList, stockMoveLineList);
        diffConsumeList.forEach(prodProduct -> prodProduct.setDiffConsumeOperationOrder(operationOrder));
        return diffConsumeList;
    }

    @Override
    public void checkConsumedStockMoveLineList(OperationOrder operationOrder, OperationOrder oldOperationOrder) throws AxelorException {
        ((ManufOrderService)Beans.get(ManufOrderService.class)).checkRealizedStockMoveLineList(operationOrder.getConsumedStockMoveLineList(), oldOperationOrder.getConsumedStockMoveLineList());
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void updateConsumedStockMoveFromOperationOrder(OperationOrder operationOrder) throws AxelorException {
        StockMove stockMove2;
        this.updateDiffProdProductList(operationOrder);
        List<StockMoveLine> consumedStockMoveLineList = operationOrder.getConsumedStockMoveLineList();
        if (consumedStockMoveLineList == null) {
            return;
        }
        Optional<StockMove> stockMoveOpt = operationOrder.getInStockMoveList().stream().filter(stockMove -> stockMove.getStatusSelect() == 2).findFirst();
        if (stockMoveOpt.isPresent()) {
            stockMove2 = stockMoveOpt.get();
        } else {
            stockMove2 = ((ManufOrderStockMoveService)Beans.get(ManufOrderStockMoveService.class))._createToConsumeStockMove(operationOrder.getManufOrder(), operationOrder.getManufOrder().getCompany());
            operationOrder.addInStockMoveListItem(stockMove2);
            ((StockMoveService)Beans.get(StockMoveService.class)).plan(stockMove2);
        }
        ((ManufOrderService)Beans.get(ManufOrderService.class)).updateStockMoveFromManufOrder(consumedStockMoveLineList, stockMove2);
    }

    @Override
    public void createBarcode(OperationOrder operationOrder) {
        try {
            String stringId = operationOrder.getId().toString();
            boolean addPadding = true;
            InputStream inStream = this.barcodeGeneratorService.createBarCode(stringId, this.appProductionService.getAppProduction().getBarcodeTypeConfig(), addPadding);
            if (inStream != null) {
                MetaFile barcodeFile = this.metaFiles.upload(inStream, String.format("OppOrderBarcode%d.png", operationOrder.getId()));
                operationOrder.setBarCode(barcodeFile);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (AxelorException e) {
            throw new ValidationException(e.getMessage());
        }
    }
}

