/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service.operationorder;

import com.axelor.apps.production.db.Machine;
import com.axelor.apps.production.db.ManufOrder;
import com.axelor.apps.production.db.OperationOrder;
import com.axelor.apps.production.db.OperationOrderDuration;
import com.axelor.apps.production.db.ProdProcessLine;
import com.axelor.apps.production.db.WorkCenter;
import com.axelor.apps.production.db.repo.OperationOrderDurationRepository;
import com.axelor.apps.production.db.repo.OperationOrderRepository;
import com.axelor.apps.production.service.app.AppProductionService;
import com.axelor.apps.production.service.manuforder.ManufOrderStockMoveService;
import com.axelor.apps.production.service.manuforder.ManufOrderWorkflowService;
import com.axelor.apps.production.service.operationorder.OperationOrderService;
import com.axelor.apps.production.service.operationorder.OperationOrderStockMoveService;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.service.StockMoveService;
import com.axelor.apps.tool.date.DurationTool;
import com.axelor.auth.AuthUtils;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class OperationOrderWorkflowService {
    protected OperationOrderStockMoveService operationOrderStockMoveService;
    protected OperationOrderRepository operationOrderRepo;
    protected OperationOrderDurationRepository operationOrderDurationRepo;
    protected AppProductionService appProductionService;

    @Inject
    public OperationOrderWorkflowService(OperationOrderStockMoveService operationOrderStockMoveService, OperationOrderRepository operationOrderRepo, OperationOrderDurationRepository operationOrderDurationRepo, AppProductionService appProductionService) {
        this.operationOrderStockMoveService = operationOrderStockMoveService;
        this.operationOrderRepo = operationOrderRepo;
        this.operationOrderDurationRepo = operationOrderDurationRepo;
        this.appProductionService = appProductionService;
    }

    @Transactional(rollbackOn={Exception.class})
    public OperationOrder plan(OperationOrder operationOrder) throws AxelorException {
        if (CollectionUtils.isEmpty(operationOrder.getToConsumeProdProductList())) {
            ((OperationOrderService)Beans.get(OperationOrderService.class)).createToConsumeProdProductList(operationOrder);
        }
        operationOrder.setPlannedStartDateT(this.getLastOperationOrder(operationOrder));
        operationOrder.setPlannedEndDateT(this.computePlannedEndDateT(operationOrder));
        operationOrder.setPlannedDuration(DurationTool.getSecondsDuration((Duration)Duration.between(operationOrder.getPlannedStartDateT(), operationOrder.getPlannedEndDateT())));
        ManufOrder manufOrder = operationOrder.getManufOrder();
        if (manufOrder == null || manufOrder.getIsConsProOnOperation().booleanValue()) {
            this.operationOrderStockMoveService.createToConsumeStockMove(operationOrder);
        }
        operationOrder.setStatusSelect(3);
        return (OperationOrder)((Object)this.operationOrderRepo.save((Model)((Object)operationOrder)));
    }

    @Transactional(rollbackOn={Exception.class})
    public OperationOrder replan(OperationOrder operationOrder) throws AxelorException {
        operationOrder.setPlannedStartDateT(this.getLastOperationOrder(operationOrder));
        operationOrder.setPlannedEndDateT(this.computePlannedEndDateT(operationOrder));
        operationOrder.setPlannedDuration(DurationTool.getSecondsDuration((Duration)Duration.between(operationOrder.getPlannedStartDateT(), operationOrder.getPlannedEndDateT())));
        return (OperationOrder)((Object)this.operationOrderRepo.save((Model)((Object)operationOrder)));
    }

    @Transactional
    public List<OperationOrder> resetPlannedDates(List<OperationOrder> operationOrderList) {
        for (OperationOrder operationOrder : operationOrderList) {
            operationOrder.setPlannedStartDateT(null);
            operationOrder.setPlannedEndDateT(null);
            operationOrder.setPlannedDuration(null);
        }
        return operationOrderList;
    }

    public LocalDateTime getLastOperationOrder(OperationOrder operationOrder) {
        OperationOrder lastOperationOrder = (OperationOrder)((Object)this.operationOrderRepo.all().filter("self.manufOrder = ?1 AND self.priority <= ?2 AND self.statusSelect >= 3 AND self.statusSelect < 6 AND self.id != ?3", new Object[]{operationOrder.getManufOrder(), operationOrder.getPriority(), operationOrder.getId()}).order("-priority").order("-plannedEndDateT").fetchOne());
        if (lastOperationOrder != null) {
            if (lastOperationOrder.getPriority() == operationOrder.getPriority()) {
                if (lastOperationOrder.getPlannedStartDateT() != null && lastOperationOrder.getPlannedStartDateT().isAfter(operationOrder.getManufOrder().getPlannedStartDateT())) {
                    if (lastOperationOrder.getMachineWorkCenter().equals((Object)operationOrder.getMachineWorkCenter())) {
                        return lastOperationOrder.getPlannedEndDateT();
                    }
                    return lastOperationOrder.getPlannedStartDateT();
                }
                return operationOrder.getManufOrder().getPlannedStartDateT();
            }
            if (lastOperationOrder.getPlannedEndDateT() != null && lastOperationOrder.getPlannedEndDateT().isAfter(operationOrder.getManufOrder().getPlannedStartDateT())) {
                return lastOperationOrder.getPlannedEndDateT();
            }
            return operationOrder.getManufOrder().getPlannedStartDateT();
        }
        return operationOrder.getManufOrder().getPlannedStartDateT();
    }

    @Transactional(rollbackOn={Exception.class})
    public void start(OperationOrder operationOrder) throws AxelorException {
        if (operationOrder.getStatusSelect() != 4) {
            int beforeOrAfterConfig;
            operationOrder.setStatusSelect(4);
            operationOrder.setRealStartDateT(this.appProductionService.getTodayDateTime().toLocalDateTime());
            this.startOperationOrderDuration(operationOrder);
            if (operationOrder.getManufOrder() != null && (beforeOrAfterConfig = operationOrder.getManufOrder().getProdProcess().getStockMoveRealizeOrderSelect().intValue()) == 0) {
                for (StockMove stockMove : operationOrder.getInStockMoveList()) {
                    ((ManufOrderStockMoveService)Beans.get(ManufOrderStockMoveService.class)).finishStockMove(stockMove);
                }
                StockMove newStockMove = this.operationOrderStockMoveService._createToConsumeStockMove(operationOrder, operationOrder.getManufOrder().getCompany());
                newStockMove.setStockMoveLineList(new ArrayList<StockMoveLine>());
                ((StockMoveService)Beans.get(StockMoveService.class)).plan(newStockMove);
                operationOrder.addInStockMoveListItem(newStockMove);
            }
            this.operationOrderRepo.save((Model)((Object)operationOrder));
        }
        if (operationOrder.getManufOrder().getStatusSelect() != 4) {
            ((ManufOrderWorkflowService)Beans.get(ManufOrderWorkflowService.class)).start(operationOrder.getManufOrder());
        }
    }

    @Transactional
    public void pause(OperationOrder operationOrder) {
        operationOrder.setStatusSelect(5);
        this.stopOperationOrderDuration(operationOrder);
        this.operationOrderRepo.save((Model)((Object)operationOrder));
    }

    @Transactional
    public void resume(OperationOrder operationOrder) {
        operationOrder.setStatusSelect(4);
        this.startOperationOrderDuration(operationOrder);
        this.operationOrderRepo.save((Model)((Object)operationOrder));
    }

    @Transactional(rollbackOn={Exception.class})
    public void finish(OperationOrder operationOrder) throws AxelorException {
        operationOrder.setStatusSelect(6);
        operationOrder.setRealEndDateT(this.appProductionService.getTodayDateTime().toLocalDateTime());
        this.stopOperationOrderDuration(operationOrder);
        this.operationOrderStockMoveService.finish(operationOrder);
        this.operationOrderRepo.save((Model)((Object)operationOrder));
    }

    @Transactional(rollbackOn={Exception.class})
    public void finishAndAllOpFinished(OperationOrder operationOrder) throws AxelorException {
        this.finish(operationOrder);
        ((ManufOrderWorkflowService)Beans.get(ManufOrderWorkflowService.class)).allOpFinished(operationOrder.getManufOrder());
    }

    @Transactional
    public void cancel(OperationOrder operationOrder) throws AxelorException {
        int oldStatus = operationOrder.getStatusSelect();
        operationOrder.setStatusSelect(2);
        if (oldStatus == 4) {
            this.stopOperationOrderDuration(operationOrder);
        }
        if (operationOrder.getConsumedStockMoveLineList() != null) {
            operationOrder.getConsumedStockMoveLineList().forEach(stockMoveLine -> stockMoveLine.setConsumedOperationOrder(null));
        }
        this.operationOrderStockMoveService.cancel(operationOrder);
        this.operationOrderRepo.save((Model)((Object)operationOrder));
    }

    public void startOperationOrderDuration(OperationOrder operationOrder) {
        OperationOrderDuration duration = new OperationOrderDuration();
        duration.setStartedBy(AuthUtils.getUser());
        duration.setStartingDateTime(this.appProductionService.getTodayDateTime().toLocalDateTime());
        operationOrder.addOperationOrderDurationListItem(duration);
    }

    public void stopOperationOrderDuration(OperationOrder operationOrder) {
        OperationOrderDuration duration = (OperationOrderDuration)((Object)this.operationOrderDurationRepo.all().filter("self.operationOrder.id = ? AND self.stoppedBy IS NULL AND self.stoppingDateTime IS NULL", new Object[]{operationOrder.getId()}).fetchOne());
        duration.setStoppedBy(AuthUtils.getUser());
        duration.setStoppingDateTime(this.appProductionService.getTodayDateTime().toLocalDateTime());
        if (operationOrder.getStatusSelect() == 6) {
            long durationLong = DurationTool.getSecondsDuration((Duration)this.computeRealDuration(operationOrder));
            operationOrder.setRealDuration(durationLong);
            WorkCenter machineWorkCenter = operationOrder.getMachineWorkCenter();
            Machine machine = null;
            if (machineWorkCenter != null) {
                machine = machineWorkCenter.getMachine();
            } else if (operationOrder.getWorkCenter() != null) {
                machine = operationOrder.getWorkCenter().getMachine();
            }
            if (machine != null) {
                machine.setOperatingDuration(machine.getOperatingDuration() + durationLong);
            }
        }
        this.operationOrderDurationRepo.save((Model)((Object)duration));
    }

    public void updateRealDuration(OperationOrder operationOrder) {
        long durationLong = DurationTool.getSecondsDuration((Duration)this.computeRealDuration(operationOrder));
        operationOrder.setRealDuration(durationLong);
    }

    public Duration computeRealDuration(OperationOrder operationOrder) {
        Duration totalDuration = Duration.ZERO;
        List<OperationOrderDuration> operationOrderDurations = operationOrder.getOperationOrderDurationList();
        if (operationOrderDurations != null) {
            for (OperationOrderDuration operationOrderDuration : operationOrderDurations) {
                if (operationOrderDuration.getStartingDateTime() == null || operationOrderDuration.getStoppingDateTime() == null) continue;
                totalDuration = totalDuration.plus(Duration.between(operationOrderDuration.getStartingDateTime(), operationOrderDuration.getStoppingDateTime()));
            }
        }
        return totalDuration;
    }

    @Transactional
    public OperationOrder setPlannedDates(OperationOrder operationOrder, LocalDateTime plannedStartDateT, LocalDateTime plannedEndDateT) {
        operationOrder.setPlannedStartDateT(plannedStartDateT);
        operationOrder.setPlannedEndDateT(plannedEndDateT);
        return this.computeDuration(operationOrder);
    }

    @Transactional
    public OperationOrder setRealDates(OperationOrder operationOrder, LocalDateTime realStartDateT, LocalDateTime realEndDateT) {
        operationOrder.setRealStartDateT(realStartDateT);
        operationOrder.setRealEndDateT(realEndDateT);
        return this.computeDuration(operationOrder);
    }

    @Transactional
    public OperationOrder computeDuration(OperationOrder operationOrder) {
        if (operationOrder.getPlannedStartDateT() != null && operationOrder.getPlannedEndDateT() != null) {
            Long duration = DurationTool.getSecondsDuration((Duration)Duration.between(operationOrder.getPlannedStartDateT(), operationOrder.getPlannedEndDateT()));
            operationOrder.setPlannedDuration(duration);
        }
        this.updateRealDuration(operationOrder);
        return operationOrder;
    }

    public LocalDateTime computePlannedEndDateT(OperationOrder operationOrder) throws AxelorException {
        if (operationOrder.getWorkCenter() != null) {
            return operationOrder.getPlannedStartDateT().plusSeconds((int)this.computeEntireCycleDuration(operationOrder, operationOrder.getManufOrder().getQty()));
        }
        return operationOrder.getPlannedStartDateT();
    }

    public long computeEntireCycleDuration(OperationOrder operationOrder, BigDecimal qty) throws AxelorException {
        ProdProcessLine prodProcessLine = operationOrder.getProdProcessLine();
        WorkCenter workCenter = prodProcessLine.getWorkCenter();
        long duration = 0L;
        BigDecimal maxCapacityPerCycle = prodProcessLine.getMaxCapacityPerCycle();
        BigDecimal nbCycles = maxCapacityPerCycle.compareTo(BigDecimal.ZERO) == 0 ? qty : qty.divide(maxCapacityPerCycle, 0, RoundingMode.UP);
        int workCenterTypeSelect = workCenter.getWorkCenterTypeSelect();
        if (workCenterTypeSelect == 2 || workCenterTypeSelect == 3) {
            Machine machine = workCenter.getMachine();
            if (machine == null) {
                throw new AxelorException((Model)((Object)workCenter), 1, I18n.get((String)"Please fill the machine in the workcenter %s."), new Object[]{workCenter.getName()});
            }
            duration += machine.getStartingDuration().longValue();
            duration += machine.getEndingDuration().longValue();
            duration += nbCycles.subtract(new BigDecimal(1)).multiply(new BigDecimal(machine.getSetupDuration())).longValue();
        }
        BigDecimal durationPerCycle = new BigDecimal(prodProcessLine.getDurationPerCycle());
        return duration += nbCycles.multiply(durationPerCycle).longValue();
    }
}

