/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.service.productionorder;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.service.UnitConversionService;
import com.axelor.apps.production.db.BillOfMaterial;
import com.axelor.apps.production.db.ProductionOrder;
import com.axelor.apps.production.db.repo.ProductionOrderRepository;
import com.axelor.apps.production.service.app.AppProductionService;
import com.axelor.apps.production.service.productionorder.ProductionOrderSaleOrderService;
import com.axelor.apps.production.service.productionorder.ProductionOrderService;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductionOrderSaleOrderServiceImpl
implements ProductionOrderSaleOrderService {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected UnitConversionService unitConversionService;
    protected ProductionOrderService productionOrderService;
    protected ProductionOrderRepository productionOrderRepo;
    protected AppProductionService appProductionService;

    @Inject
    public ProductionOrderSaleOrderServiceImpl(UnitConversionService unitConversionService, ProductionOrderService productionOrderService, ProductionOrderRepository productionOrderRepo, AppProductionService appProductionService) {
        this.unitConversionService = unitConversionService;
        this.productionOrderService = productionOrderService;
        this.productionOrderRepo = productionOrderRepo;
        this.appProductionService = appProductionService;
    }

    @Override
    public List<Long> generateProductionOrder(SaleOrder saleOrder) throws AxelorException {
        boolean oneProdOrderPerSO = this.appProductionService.getAppProduction().getOneProdOrderPerSO();
        ArrayList<Long> productionOrderIdList = new ArrayList<Long>();
        if (saleOrder.getSaleOrderLineList() == null) {
            return productionOrderIdList;
        }
        ProductionOrder productionOrder = null;
        for (SaleOrderLine saleOrderLine : saleOrder.getSaleOrderLineList()) {
            if (productionOrder == null || !oneProdOrderPerSO) {
                productionOrder = this.createProductionOrder(saleOrder);
            }
            if ((productionOrder = this.generateManufOrder(productionOrder, saleOrderLine)) == null || productionOrderIdList.contains(productionOrder.getId())) continue;
            productionOrderIdList.add(productionOrder.getId());
        }
        return productionOrderIdList;
    }

    protected ProductionOrder createProductionOrder(SaleOrder saleOrder) throws AxelorException {
        return this.productionOrderService.createProductionOrder(saleOrder);
    }

    @Override
    public ProductionOrder generateManufOrder(ProductionOrder productionOrder, SaleOrderLine saleOrderLine) throws AxelorException {
        Product product = saleOrderLine.getProduct();
        if (saleOrderLine.getSaleSupplySelect() == 3 && product != null && product.getProductTypeSelect().equals("storable")) {
            BillOfMaterial billOfMaterial = saleOrderLine.getBillOfMaterial();
            if (billOfMaterial == null) {
                billOfMaterial = product.getDefaultBillOfMaterial();
            }
            if (billOfMaterial == null && product.getParentProduct() != null) {
                billOfMaterial = product.getParentProduct().getDefaultBillOfMaterial();
            }
            if (billOfMaterial == null) {
                throw new AxelorException((Model)((Object)saleOrderLine), 4, I18n.get((String)"There no's defined nomenclature for product %s (%s)"), new Object[]{product.getName(), product.getCode()});
            }
            if (billOfMaterial.getProdProcess() == null) {
                return null;
            }
            Unit unit = saleOrderLine.getProduct().getUnit();
            BigDecimal qty = saleOrderLine.getQty();
            if (unit != null && !unit.equals((Object)saleOrderLine.getUnit())) {
                qty = this.unitConversionService.convert(saleOrderLine.getUnit(), unit, qty, qty.scale(), saleOrderLine.getProduct());
            }
            return this.productionOrderService.addManufOrder(productionOrder, product, billOfMaterial, qty, LocalDateTime.now(), null, saleOrderLine.getSaleOrder(), 2);
        }
        return null;
    }
}

