/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.web;

import com.axelor.apps.production.db.BillOfMaterial;
import com.axelor.apps.production.db.CostSheet;
import com.axelor.apps.production.db.TempBomTree;
import com.axelor.apps.production.db.repo.BillOfMaterialRepository;
import com.axelor.apps.production.service.BillOfMaterialService;
import com.axelor.apps.production.service.ProdProcessService;
import com.axelor.apps.production.service.costsheet.CostSheetService;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.exception.AxelorException;
import com.axelor.exception.ResponseMessageType;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class BillOfMaterialController {
    private static final Logger LOG = LoggerFactory.getLogger(BillOfMaterialController.class);

    public void computeCostPrice(ActionRequest request, ActionResponse response) throws AxelorException {
        BillOfMaterial billOfMaterial = (BillOfMaterial)((Object)request.getContext().asType(BillOfMaterial.class));
        CostSheet costSheet = ((CostSheetService)Beans.get(CostSheetService.class)).computeCostPrice((BillOfMaterial)((Object)((BillOfMaterialRepository)((Object)Beans.get(BillOfMaterialRepository.class))).find(billOfMaterial.getId())), 0, null);
        response.setView(ActionView.define((String)String.format(I18n.get((String)"Cost sheet - %s"), billOfMaterial.getName())).model(CostSheet.class.getName()).param("popup", "true").param("show-toolbar", "false").param("show-confirm", "false").param("popup-save", "false").add("grid", "cost-sheet-bill-of-material-grid").add("form", "cost-sheet-bill-of-material-form").context("_showRecord", (Object)String.valueOf(costSheet.getId())).map());
        response.setReload(true);
    }

    public void updateProductCostPrice(ActionRequest request, ActionResponse response) throws AxelorException {
        BillOfMaterial billOfMaterial = (BillOfMaterial)((Object)request.getContext().asType(BillOfMaterial.class));
        ((BillOfMaterialService)Beans.get(BillOfMaterialService.class)).updateProductCostPrice((BillOfMaterial)((Object)((BillOfMaterialRepository)((Object)Beans.get(BillOfMaterialRepository.class))).find(billOfMaterial.getId())));
        response.setReload(true);
    }

    public void checkOriginalBillOfMaterial(ActionRequest request, ActionResponse response) {
        String message;
        BillOfMaterialRepository billOfMaterialRepository = (BillOfMaterialRepository)((Object)Beans.get(BillOfMaterialRepository.class));
        BillOfMaterial billOfMaterial = (BillOfMaterial)((Object)billOfMaterialRepository.find(((BillOfMaterial)((Object)request.getContext().asType(BillOfMaterial.class))).getId()));
        List BillOfMaterialSet = Lists.newArrayList();
        BillOfMaterialSet = billOfMaterialRepository.all().filter("self.originalBillOfMaterial = :origin").bind("origin", (Object)billOfMaterial).fetch();
        if (!BillOfMaterialSet.isEmpty()) {
            String existingVersions = "";
            for (BillOfMaterial billOfMaterialVersion : BillOfMaterialSet) {
                existingVersions = existingVersions + "<li>" + billOfMaterialVersion.getFullName() + "</li>";
            }
            message = String.format(I18n.get((String)"This bill of material already has the following versions : <br/><ul> %s </ul>And these versions may also have ones. Do you still wish to create a new one ?"), existingVersions);
        } else {
            message = I18n.get((String)"Do you really wish to create a new version of this bill of material ?");
        }
        response.setAlert(message);
    }

    public void generateNewVersion(ActionRequest request, ActionResponse response) {
        BillOfMaterial billOfMaterial = (BillOfMaterial)((Object)((BillOfMaterialRepository)((Object)Beans.get(BillOfMaterialRepository.class))).find(((BillOfMaterial)((Object)request.getContext().asType(BillOfMaterial.class))).getId()));
        BillOfMaterial copy = ((BillOfMaterialService)Beans.get(BillOfMaterialService.class)).generateNewVersion(billOfMaterial);
        response.setView(ActionView.define((String)"Bill of material").model(BillOfMaterial.class.getName()).add("form", "bill-of-material-form").add("grid", "bill-of-material-grid").domain("self.defineSubBillOfMaterial = true AND self.personalized = false").context("_showRecord", (Object)String.valueOf(copy.getId())).map());
    }

    public void validateProdProcess(ActionRequest request, ActionResponse response) {
        BillOfMaterial billOfMaterial = (BillOfMaterial)((Object)request.getContext().asType(BillOfMaterial.class));
        if (billOfMaterial != null && billOfMaterial.getProdProcess() != null && billOfMaterial.getProdProcess().getIsConsProOnOperation().booleanValue()) {
            try {
                ((ProdProcessService)Beans.get(ProdProcessService.class)).validateProdProcess(billOfMaterial.getProdProcess(), billOfMaterial);
            }
            catch (AxelorException e) {
                TraceBackService.trace((ActionResponse)response, (Throwable)e, (ResponseMessageType)ResponseMessageType.ERROR);
            }
        }
    }

    public void print(ActionRequest request, ActionResponse response) throws AxelorException {
        BillOfMaterial billOfMaterial = (BillOfMaterial)((Object)request.getContext().asType(BillOfMaterial.class));
        BillOfMaterialService billOfMaterialService = (BillOfMaterialService)Beans.get(BillOfMaterialService.class);
        String language = ReportSettings.getPrintingLocale(null);
        String name = billOfMaterialService.getFileName(billOfMaterial);
        String fileLink = billOfMaterialService.getReportLink(billOfMaterial, name, language, "pdf");
        LOG.debug("Printing " + name);
        response.setView(ActionView.define((String)name).add("html", fileLink).map());
    }

    public void openBomTree(ActionRequest request, ActionResponse response) {
        BillOfMaterial billOfMaterial = (BillOfMaterial)((Object)request.getContext().asType(BillOfMaterial.class));
        billOfMaterial = (BillOfMaterial)((Object)((BillOfMaterialRepository)((Object)Beans.get(BillOfMaterialRepository.class))).find(billOfMaterial.getId()));
        TempBomTree tempBomTree = ((BillOfMaterialService)Beans.get(BillOfMaterialService.class)).generateTree(billOfMaterial);
        response.setView(ActionView.define((String)I18n.get((String)"Bill of material")).model(TempBomTree.class.getName()).add("tree", "bill-of-material-tree").context("_tempBomTreeId", (Object)tempBomTree.getId()).map());
    }

    public void setBillOfMaterialAsDefault(ActionRequest request, ActionResponse response) {
        try {
            BillOfMaterial billOfMaterial = (BillOfMaterial)((Object)request.getContext().asType(BillOfMaterial.class));
            billOfMaterial = (BillOfMaterial)((Object)((BillOfMaterialRepository)((Object)Beans.get(BillOfMaterialRepository.class))).find(billOfMaterial.getId()));
            ((BillOfMaterialService)Beans.get(BillOfMaterialService.class)).setBillOfMaterialAsDefault(billOfMaterial);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
    }

    public void computeName(ActionRequest request, ActionResponse response) {
        BillOfMaterial billOfMaterial = (BillOfMaterial)((Object)request.getContext().asType(BillOfMaterial.class));
        if (billOfMaterial.getName() == null) {
            response.setValue("name", (Object)((BillOfMaterialService)Beans.get(BillOfMaterialService.class)).computeName(billOfMaterial));
        }
    }

    public void addRawMaterials(ActionRequest request, ActionResponse response) {
        try {
            BillOfMaterial billOfMaterial = (BillOfMaterial)((Object)request.getContext().asType(BillOfMaterial.class));
            ArrayList rawMaterials = (ArrayList)request.getContext().get((Object)"rawMaterials");
            if (rawMaterials != null && !rawMaterials.isEmpty()) {
                ((BillOfMaterialService)Beans.get(BillOfMaterialService.class)).addRawMaterials(billOfMaterial.getId(), rawMaterials);
                response.setReload(true);
            }
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
    }
}

