/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.web;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.production.db.CostSheet;
import com.axelor.apps.production.db.ManufOrder;
import com.axelor.apps.production.db.repo.ManufOrderRepository;
import com.axelor.apps.production.service.costsheet.CostSheetService;
import com.axelor.apps.production.service.manuforder.ManufOrderService;
import com.axelor.apps.production.service.manuforder.ManufOrderStockMoveService;
import com.axelor.apps.production.service.manuforder.ManufOrderWorkflowService;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.common.base.Strings;
import com.google.inject.Singleton;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ManufOrderController {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void start(ActionRequest request, ActionResponse response) {
        try {
            Long manufOrderId = (Long)request.getContext().get((Object)"id");
            ManufOrder manufOrder = (ManufOrder)((Object)((ManufOrderRepository)((Object)Beans.get(ManufOrderRepository.class))).find(manufOrderId));
            ((ManufOrderWorkflowService)Beans.get(ManufOrderWorkflowService.class)).start(manufOrder);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void pause(ActionRequest request, ActionResponse response) {
        try {
            Long manufOrderId = (Long)request.getContext().get((Object)"id");
            ManufOrder manufOrder = (ManufOrder)((Object)((ManufOrderRepository)((Object)Beans.get(ManufOrderRepository.class))).find(manufOrderId));
            ((ManufOrderWorkflowService)Beans.get(ManufOrderWorkflowService.class)).pause(manufOrder);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void resume(ActionRequest request, ActionResponse response) {
        try {
            Long manufOrderId = (Long)request.getContext().get((Object)"id");
            ManufOrder manufOrder = (ManufOrder)((Object)((ManufOrderRepository)((Object)Beans.get(ManufOrderRepository.class))).find(manufOrderId));
            ((ManufOrderWorkflowService)Beans.get(ManufOrderWorkflowService.class)).resume(manufOrder);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void finish(ActionRequest request, ActionResponse response) {
        try {
            Long manufOrderId = (Long)request.getContext().get((Object)"id");
            ManufOrder manufOrder = (ManufOrder)((Object)((ManufOrderRepository)((Object)Beans.get(ManufOrderRepository.class))).find(manufOrderId));
            if (!((ManufOrderWorkflowService)Beans.get(ManufOrderWorkflowService.class)).finish(manufOrder)) {
                response.setNotify(I18n.get((String)"Automatic email was not sent because no default email account and/or no valid email account was found : please create one."));
            }
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void partialFinish(ActionRequest request, ActionResponse response) {
        try {
            ManufOrder manufOrder = (ManufOrder)((Object)request.getContext().asType(ManufOrder.class));
            manufOrder = (ManufOrder)((Object)((ManufOrderRepository)((Object)Beans.get(ManufOrderRepository.class))).find(manufOrder.getId()));
            if (!((ManufOrderWorkflowService)Beans.get(ManufOrderWorkflowService.class)).partialFinish(manufOrder)) {
                response.setNotify(I18n.get((String)"Automatic email was not sent because no default email account and/or no valid email account was found : please create one."));
            }
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void cancel(ActionRequest request, ActionResponse response) {
        try {
            Context context = request.getContext();
            ManufOrder manufOrder = (ManufOrder)((Object)context.asType(ManufOrder.class));
            ((ManufOrderWorkflowService)Beans.get(ManufOrderWorkflowService.class)).cancel((ManufOrder)((Object)((ManufOrderRepository)((Object)Beans.get(ManufOrderRepository.class))).find(manufOrder.getId())), manufOrder.getCancelReason(), manufOrder.getCancelReasonStr());
            response.setFlash(I18n.get((String)"The manufacturing order was canceled."));
            response.setCanClose(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void plan(ActionRequest request, ActionResponse response) {
        try {
            Context context = request.getContext();
            List<Model> manufOrders = new ArrayList<Model>();
            if (context.get((Object)"id") != null) {
                Long manufOrderId = (Long)request.getContext().get((Object)"id");
                manufOrders.add(((ManufOrderRepository)((Object)Beans.get(ManufOrderRepository.class))).find(manufOrderId));
            } else if (context.get((Object)"_ids") != null) {
                manufOrders = ((ManufOrderRepository)((Object)Beans.get(ManufOrderRepository.class))).all().filter("self.id in ?1 and self.statusSelect in (?2,?3)", new Object[]{context.get((Object)"_ids"), 1, 2}).fetch();
            }
            for (ManufOrder manufOrder : manufOrders) {
                ((ManufOrderWorkflowService)Beans.get(ManufOrderWorkflowService.class)).plan(manufOrder);
            }
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void consumeStockMove(ActionRequest request, ActionResponse response) {
        try {
            ManufOrder manufOrder = (ManufOrder)((Object)request.getContext().asType(ManufOrder.class));
            manufOrder = (ManufOrder)((Object)((ManufOrderRepository)((Object)Beans.get(ManufOrderRepository.class))).find(manufOrder.getId()));
            ((ManufOrderStockMoveService)Beans.get(ManufOrderStockMoveService.class)).consumeInStockMoves(manufOrder);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void print(ActionRequest request, ActionResponse response) {
        try {
            ManufOrder manufOrder = (ManufOrder)((Object)request.getContext().asType(ManufOrder.class));
            String manufOrderIds = "";
            List lstSelectedManufOrder = (List)request.getContext().get((Object)"_ids");
            if (lstSelectedManufOrder != null) {
                for (Integer it : lstSelectedManufOrder) {
                    manufOrderIds = manufOrderIds + it.toString() + ",";
                }
            }
            if (!manufOrderIds.equals("")) {
                manufOrderIds = manufOrderIds.substring(0, manufOrderIds.length() - 1);
                manufOrder = (ManufOrder)((Object)((ManufOrderRepository)((Object)Beans.get(ManufOrderRepository.class))).find(new Long(((Integer)lstSelectedManufOrder.get(0)).intValue())));
            } else if (manufOrder.getId() != null) {
                manufOrderIds = manufOrder.getId().toString();
            }
            if (!manufOrderIds.equals("")) {
                String name = lstSelectedManufOrder == null ? String.format("%s %s", I18n.get((String)"Manufacturing order"), Strings.nullToEmpty((String)manufOrder.getManufOrderSeq())) : I18n.get((String)"Manufacturing orders");
                String fileLink = ReportFactory.createReport((String)"ManufOrder.rptdesign", (String)(name + "-${date}")).addParam("Locale", (Object)ReportSettings.getPrintingLocale(null)).addParam("ManufOrderId", (Object)manufOrderIds).addParam("activateBarCodeGeneration", (Object)((AppBaseService)Beans.get(AppBaseService.class)).getAppBase().getActivateBarCodeGeneration()).generate().getFileLink();
                LOG.debug("Printing {}", (Object)name);
                response.setView(ActionView.define((String)name).add("html", fileLink).map());
            } else {
                response.setFlash(I18n.get((String)"Please select the Manufacturing order(s) to print."));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void preFillOperations(ActionRequest request, ActionResponse response) throws AxelorException {
        try {
            ManufOrder manufOrder = (ManufOrder)((Object)request.getContext().asType(ManufOrder.class));
            ManufOrderService moService = (ManufOrderService)Beans.get(ManufOrderService.class);
            manufOrder = (ManufOrder)((Object)((ManufOrderRepository)((Object)Beans.get(ManufOrderRepository.class))).find(manufOrder.getId()));
            moService.preFillOperations(manufOrder);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void generateWasteStockMove(ActionRequest request, ActionResponse response) {
        try {
            ManufOrder manufOrder = (ManufOrder)((Object)request.getContext().asType(ManufOrder.class));
            manufOrder = (ManufOrder)((Object)((ManufOrderRepository)((Object)Beans.get(ManufOrderRepository.class))).find(manufOrder.getId()));
            ((ManufOrderService)Beans.get(ManufOrderService.class)).generateWasteStockMove(manufOrder);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void updatePlannedQty(ActionRequest request, ActionResponse response) {
        try {
            ManufOrder manufOrder = (ManufOrder)((Object)request.getContext().asType(ManufOrder.class));
            manufOrder = (ManufOrder)((Object)((ManufOrderRepository)((Object)Beans.get(ManufOrderRepository.class))).find(manufOrder.getId()));
            ((ManufOrderService)Beans.get(ManufOrderService.class)).updatePlannedQty(manufOrder);
            response.setReload(true);
            response.setCanClose(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void updateRealQty(ActionRequest request, ActionResponse response) {
        try {
            ManufOrder manufOrder = (ManufOrder)((Object)request.getContext().asType(ManufOrder.class));
            manufOrder = (ManufOrder)((Object)((ManufOrderRepository)((Object)Beans.get(ManufOrderRepository.class))).find(manufOrder.getId()));
            BigDecimal qtyToUpdate = new BigDecimal(request.getContext().get((Object)"qtyToUpdate").toString());
            ((ManufOrderService)Beans.get(ManufOrderService.class)).updateRealQty(manufOrder, qtyToUpdate);
            response.setReload(true);
            response.setCanClose(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void printProdProcess(ActionRequest request, ActionResponse response) {
        try {
            ManufOrder manufOrder = (ManufOrder)((Object)request.getContext().asType(ManufOrder.class));
            String prodProcessId = manufOrder.getProdProcess().getId().toString();
            String prodProcessLable = manufOrder.getProdProcess().getName();
            String fileLink = ReportFactory.createReport((String)"ProdProcess.rptdesign", (String)(prodProcessLable + "-${date}")).addParam("Locale", (Object)ReportSettings.getPrintingLocale(null)).addParam("ProdProcessId", (Object)prodProcessId).generate().getFileLink();
            response.setView(ActionView.define((String)prodProcessLable).add("html", fileLink).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void updatePlannedDates(ActionRequest request, ActionResponse response) {
        try {
            ManufOrder manufOrderView = (ManufOrder)((Object)request.getContext().asType(ManufOrder.class));
            if (manufOrderView.getStatusSelect() == 3) {
                ManufOrder manufOrder = (ManufOrder)((Object)((ManufOrderRepository)((Object)Beans.get(ManufOrderRepository.class))).find(manufOrderView.getId()));
                if (manufOrderView.getPlannedStartDateT() != null) {
                    if (!manufOrderView.getPlannedStartDateT().isEqual(manufOrder.getPlannedStartDateT())) {
                        ((ManufOrderWorkflowService)Beans.get(ManufOrderWorkflowService.class)).updatePlannedDates(manufOrder, manufOrderView.getPlannedStartDateT());
                        response.setReload(true);
                    }
                } else {
                    response.setValue("plannedStartDateT", (Object)manufOrder.getPlannedStartDateT());
                }
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void checkProducedStockMoveLineList(ActionRequest request, ActionResponse response) {
        try {
            ManufOrder manufOrder = (ManufOrder)((Object)request.getContext().asType(ManufOrder.class));
            ManufOrder oldManufOrder = (ManufOrder)((Object)((ManufOrderRepository)((Object)Beans.get(ManufOrderRepository.class))).find(manufOrder.getId()));
            ((ManufOrderService)Beans.get(ManufOrderService.class)).checkProducedStockMoveLineList(manufOrder, oldManufOrder);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
            response.setReload(true);
        }
    }

    public void updateProducedStockMoveFromManufOrder(ActionRequest request, ActionResponse response) {
        try {
            ManufOrder manufOrder = (ManufOrder)((Object)request.getContext().asType(ManufOrder.class));
            manufOrder = (ManufOrder)((Object)((ManufOrderRepository)((Object)Beans.get(ManufOrderRepository.class))).find(manufOrder.getId()));
            ((ManufOrderService)Beans.get(ManufOrderService.class)).updateProducedStockMoveFromManufOrder(manufOrder);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void checkConsumedStockMoveLineList(ActionRequest request, ActionResponse response) {
        try {
            ManufOrder manufOrder = (ManufOrder)((Object)request.getContext().asType(ManufOrder.class));
            ManufOrder oldManufOrder = (ManufOrder)((Object)((ManufOrderRepository)((Object)Beans.get(ManufOrderRepository.class))).find(manufOrder.getId()));
            ((ManufOrderService)Beans.get(ManufOrderService.class)).checkConsumedStockMoveLineList(manufOrder, oldManufOrder);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
            response.setReload(true);
        }
    }

    public void updateConsumedStockMoveFromManufOrder(ActionRequest request, ActionResponse response) {
        try {
            ManufOrder manufOrder = (ManufOrder)((Object)request.getContext().asType(ManufOrder.class));
            manufOrder = (ManufOrder)((Object)((ManufOrderRepository)((Object)Beans.get(ManufOrderRepository.class))).find(manufOrder.getId()));
            ((ManufOrderService)Beans.get(ManufOrderService.class)).updateConsumedStockMoveFromManufOrder(manufOrder);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void computeCostPrice(ActionRequest request, ActionResponse response) {
        try {
            ManufOrder manufOrder = (ManufOrder)((Object)request.getContext().asType(ManufOrder.class));
            manufOrder = (ManufOrder)((Object)((ManufOrderRepository)((Object)Beans.get(ManufOrderRepository.class))).find(manufOrder.getId()));
            CostSheet costSheet = ((CostSheetService)Beans.get(CostSheetService.class)).computeCostPrice(manufOrder, 3, ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate());
            response.setView(ActionView.define((String)I18n.get((String)"Cost sheet")).model(CostSheet.class.getName()).param("popup", "true").param("show-toolbar", "false").param("show-confirm", "false").param("popup-save", "false").add("grid", "cost-sheet-bill-of-material-grid").add("form", "cost-sheet-bill-of-material-form").context("_showRecord", (Object)String.valueOf(costSheet.getId())).map());
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

