/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.web;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.production.db.OperationOrder;
import com.axelor.apps.production.db.repo.OperationOrderRepository;
import com.axelor.apps.production.service.manuforder.ManufOrderWorkflowService;
import com.axelor.apps.production.service.operationorder.OperationOrderService;
import com.axelor.apps.production.service.operationorder.OperationOrderStockMoveService;
import com.axelor.apps.production.service.operationorder.OperationOrderWorkflowService;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import java.lang.invoke.MethodHandles;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OperationOrderController {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void computeDuration(ActionRequest request, ActionResponse response) {
        OperationOrder operationOrder = (OperationOrder)((Object)request.getContext().asType(OperationOrder.class));
        operationOrder = (OperationOrder)((Object)((OperationOrderRepository)((Object)Beans.get(OperationOrderRepository.class))).find(operationOrder.getId()));
        ((OperationOrderWorkflowService)Beans.get(OperationOrderWorkflowService.class)).computeDuration(operationOrder);
        response.setReload(true);
    }

    public void setPlannedDates(ActionRequest request, ActionResponse response) {
        OperationOrder operationOrder = (OperationOrder)((Object)request.getContext().asType(OperationOrder.class));
        LocalDateTime plannedStartDateT = operationOrder.getPlannedStartDateT();
        LocalDateTime plannedEndDateT = operationOrder.getPlannedEndDateT();
        operationOrder = (OperationOrder)((Object)((OperationOrderRepository)((Object)Beans.get(OperationOrderRepository.class))).find(operationOrder.getId()));
        ((OperationOrderWorkflowService)Beans.get(OperationOrderWorkflowService.class)).setPlannedDates(operationOrder, plannedStartDateT, plannedEndDateT);
    }

    public void setRealDates(ActionRequest request, ActionResponse response) {
        OperationOrder operationOrder = (OperationOrder)((Object)request.getContext().asType(OperationOrder.class));
        LocalDateTime realStartDateT = operationOrder.getRealStartDateT();
        LocalDateTime realEndDateT = operationOrder.getRealEndDateT();
        operationOrder = (OperationOrder)((Object)((OperationOrderRepository)((Object)Beans.get(OperationOrderRepository.class))).find(operationOrder.getId()));
        ((OperationOrderWorkflowService)Beans.get(OperationOrderWorkflowService.class)).setRealDates(operationOrder, realStartDateT, realEndDateT);
    }

    public void machineChange(ActionRequest request, ActionResponse response) {
        try {
            OperationOrder operationOrder = (OperationOrder)((Object)request.getContext().asType(OperationOrder.class));
            OperationOrderRepository operationOrderRepo = (OperationOrderRepository)((Object)Beans.get(OperationOrderRepository.class));
            OperationOrderWorkflowService operationOrderWorkflowService = (OperationOrderWorkflowService)Beans.get(OperationOrderWorkflowService.class);
            operationOrder = (OperationOrder)((Object)operationOrderRepo.find(operationOrder.getId()));
            if (operationOrder != null && operationOrder.getStatusSelect() == 3) {
                operationOrder = operationOrderWorkflowService.replan(operationOrder);
                List operationOrderList = operationOrderRepo.all().filter("self.manufOrder = ?1 AND self.priority >= ?2 AND self.statusSelect = 3 AND self.id != ?3", new Object[]{operationOrder.getManufOrder(), operationOrder.getPriority(), operationOrder.getId()}).order("priority").order("plannedEndDateT").fetch();
                for (OperationOrder operationOrderIt : operationOrderList) {
                    operationOrderWorkflowService.replan(operationOrderIt);
                }
                response.setReload(true);
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void plan(ActionRequest request, ActionResponse response) {
        try {
            OperationOrder operationOrder = (OperationOrder)((Object)request.getContext().asType(OperationOrder.class));
            if (operationOrder.getManufOrder() != null && operationOrder.getManufOrder().getStatusSelect() < 3) {
                return;
            }
            ((OperationOrderWorkflowService)Beans.get(OperationOrderWorkflowService.class)).plan((OperationOrder)((Object)((OperationOrderRepository)((Object)Beans.get(OperationOrderRepository.class))).find(operationOrder.getId())));
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void start(ActionRequest request, ActionResponse response) {
        try {
            OperationOrder operationOrder = (OperationOrder)((Object)request.getContext().asType(OperationOrder.class));
            operationOrder = (OperationOrder)((Object)((OperationOrderRepository)((Object)Beans.get(OperationOrderRepository.class))).find(operationOrder.getId()));
            ((OperationOrderWorkflowService)Beans.get(OperationOrderWorkflowService.class)).start(operationOrder);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void pause(ActionRequest request, ActionResponse response) {
        try {
            OperationOrder operationOrder = (OperationOrder)((Object)request.getContext().asType(OperationOrder.class));
            operationOrder = (OperationOrder)((Object)((OperationOrderRepository)((Object)Beans.get(OperationOrderRepository.class))).find(operationOrder.getId()));
            ((OperationOrderWorkflowService)Beans.get(OperationOrderWorkflowService.class)).pause(operationOrder);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void resume(ActionRequest request, ActionResponse response) {
        try {
            OperationOrder operationOrder = (OperationOrder)((Object)request.getContext().asType(OperationOrder.class));
            operationOrder = (OperationOrder)((Object)((OperationOrderRepository)((Object)Beans.get(OperationOrderRepository.class))).find(operationOrder.getId()));
            ((ManufOrderWorkflowService)Beans.get(ManufOrderWorkflowService.class)).resume(operationOrder.getManufOrder());
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void finish(ActionRequest request, ActionResponse response) {
        try {
            OperationOrder operationOrder = (OperationOrder)((Object)request.getContext().asType(OperationOrder.class));
            LocalDateTime realStartDateT = operationOrder.getRealStartDateT();
            operationOrder = (OperationOrder)((Object)((OperationOrderRepository)((Object)Beans.get(OperationOrderRepository.class))).find(operationOrder.getId()));
            operationOrder.setRealStartDateT(realStartDateT);
            ((OperationOrderWorkflowService)Beans.get(OperationOrderWorkflowService.class)).finishAndAllOpFinished(operationOrder);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void partialFinish(ActionRequest request, ActionResponse response) {
        try {
            OperationOrder operationOrder = (OperationOrder)((Object)request.getContext().asType(OperationOrder.class));
            operationOrder = (OperationOrder)((Object)((OperationOrderRepository)((Object)Beans.get(OperationOrderRepository.class))).find(operationOrder.getId()));
            ((OperationOrderStockMoveService)Beans.get(OperationOrderStockMoveService.class)).partialFinish(operationOrder);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void cancel(ActionRequest request, ActionResponse response) {
        try {
            OperationOrder operationOrder = (OperationOrder)((Object)request.getContext().asType(OperationOrder.class));
            ((OperationOrderWorkflowService)Beans.get(OperationOrderWorkflowService.class)).cancel((OperationOrder)((Object)((OperationOrderRepository)((Object)Beans.get(OperationOrderRepository.class))).find(operationOrder.getId())));
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void print(ActionRequest request, ActionResponse response) {
        OperationOrder operationOrder = (OperationOrder)((Object)request.getContext().asType(OperationOrder.class));
        String operationOrderIds = "";
        try {
            List lstSelectedOperationOrder = (List)request.getContext().get((Object)"_ids");
            if (lstSelectedOperationOrder != null) {
                for (Integer it : lstSelectedOperationOrder) {
                    operationOrderIds = operationOrderIds + it.toString() + ",";
                }
            }
            if (!operationOrderIds.equals("")) {
                operationOrderIds = operationOrderIds.substring(0, operationOrderIds.length() - 1);
                operationOrder = (OperationOrder)((Object)((OperationOrderRepository)((Object)Beans.get(OperationOrderRepository.class))).find(new Long(((Integer)lstSelectedOperationOrder.get(0)).intValue())));
            } else if (operationOrder.getId() != null) {
                operationOrderIds = operationOrder.getId().toString();
            }
            if (!operationOrderIds.equals("")) {
                String name = " ";
                if (operationOrder.getName() != null) {
                    name = name + (lstSelectedOperationOrder == null ? "Op " + operationOrder.getName() : "Ops");
                }
                String fileLink = ReportFactory.createReport((String)"OperationOrder.rptdesign", (String)(name + "-${date}")).addParam("Locale", (Object)ReportSettings.getPrintingLocale(null)).addParam("OperationOrderId", (Object)operationOrderIds).generate().getFileLink();
                LOG.debug("Printing " + name);
                response.setView(ActionView.define((String)name).add("html", fileLink).map());
            } else {
                response.setFlash(I18n.get((String)"Please select the Operation order(s) to print."));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void chargeByMachineHours(ActionRequest request, ActionResponse response) {
        try {
            LocalDateTime fromDateTime = LocalDateTime.parse(request.getContext().get((Object)"fromDateTime").toString(), DateTimeFormatter.ISO_DATE_TIME);
            LocalDateTime toDateTime = LocalDateTime.parse(request.getContext().get((Object)"toDateTime").toString(), DateTimeFormatter.ISO_DATE_TIME);
            List<Map<String, Object>> dataList = ((OperationOrderService)Beans.get(OperationOrderService.class)).chargeByMachineHours(fromDateTime, toDateTime);
            response.setData(dataList);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void chargeByMachineDays(ActionRequest request, ActionResponse response) {
        try {
            LocalDateTime fromDateTime = LocalDateTime.parse(request.getContext().get((Object)"fromDateTime").toString(), DateTimeFormatter.ISO_DATE_TIME);
            LocalDateTime toDateTime = LocalDateTime.parse(request.getContext().get((Object)"toDateTime").toString(), DateTimeFormatter.ISO_DATE_TIME);
            List<Map<String, Object>> dataList = ((OperationOrderService)Beans.get(OperationOrderService.class)).chargeByMachineDays(fromDateTime, toDateTime);
            response.setData(dataList);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void checkConsumedStockMoveLineList(ActionRequest request, ActionResponse response) {
        try {
            OperationOrder operationOrder = (OperationOrder)((Object)request.getContext().asType(OperationOrder.class));
            OperationOrder oldOperationOrder = (OperationOrder)((Object)((OperationOrderRepository)((Object)Beans.get(OperationOrderRepository.class))).find(operationOrder.getId()));
            ((OperationOrderService)Beans.get(OperationOrderService.class)).checkConsumedStockMoveLineList(operationOrder, oldOperationOrder);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
            response.setReload(true);
        }
    }

    public void updateConsumedStockMoveFromOperationOrder(ActionRequest request, ActionResponse response) {
        try {
            OperationOrder operationOrder = (OperationOrder)((Object)request.getContext().asType(OperationOrder.class));
            operationOrder = (OperationOrder)((Object)((OperationOrderRepository)((Object)Beans.get(OperationOrderRepository.class))).find(operationOrder.getId()));
            ((OperationOrderService)Beans.get(OperationOrderService.class)).updateConsumedStockMoveFromOperationOrder(operationOrder);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

