/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.web;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.repo.ProductRepository;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.production.db.BillOfMaterial;
import com.axelor.apps.production.db.ProductionOrder;
import com.axelor.apps.production.db.repo.BillOfMaterialRepository;
import com.axelor.apps.production.db.repo.ProductionOrderRepository;
import com.axelor.apps.production.service.productionorder.ProductionOrderService;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.inject.Singleton;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

@Singleton
public class ProductionOrderController {
    public void addManufOrder(ActionRequest request, ActionResponse response) throws AxelorException {
        Context context = request.getContext();
        if (context.get((Object)"qty") == null || new BigDecimal(context.get((Object)"qty").toString()).compareTo(BigDecimal.ZERO) <= 0) {
            response.setFlash(I18n.get((String)"You must add a positive quantity") + "!");
        } else if (context.get((Object)"billOfMaterial") == null) {
            response.setFlash(I18n.get((String)"You must select a nomenclature") + "!");
        } else {
            Map bomContext = (Map)context.get((Object)"billOfMaterial");
            BillOfMaterial billOfMaterial = (BillOfMaterial)((Object)((BillOfMaterialRepository)((Object)Beans.get(BillOfMaterialRepository.class))).find(((Integer)bomContext.get("id")).longValue()));
            BigDecimal qty = new BigDecimal(context.get((Object)"qty").toString());
            Product product = null;
            if (context.get((Object)"product") != null) {
                Map productContext = (Map)context.get((Object)"product");
                product = (Product)((Object)((ProductRepository)((Object)Beans.get(ProductRepository.class))).find(((Integer)productContext.get("id")).longValue()));
            } else {
                product = billOfMaterial.getProduct();
            }
            ZonedDateTime startDateT = context.containsKey((Object)"_startDate") && context.get((Object)"_startDate") != null ? ZonedDateTime.parse((CharSequence)context.get((Object)"_startDate"), DateTimeFormatter.ISO_INSTANT.withZone(ZoneId.systemDefault())) : ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDateTime();
            ProductionOrder productionOrder = (ProductionOrder)((Object)((ProductionOrderRepository)((Object)Beans.get(ProductionOrderRepository.class))).find(Long.parseLong(request.getContext().get((Object)"_id").toString())));
            if (billOfMaterial.getProdProcess() != null) {
                ((ProductionOrderService)Beans.get(ProductionOrderService.class)).addManufOrder(productionOrder, product, billOfMaterial, qty, startDateT.toLocalDateTime(), null, productionOrder.getSaleOrder(), 3);
            } else {
                response.setError(I18n.get((String)"Cannot add a manufacturing order without a production process. Please check that your chosen bill of material has a valid production process."));
            }
            response.setCanClose(true);
        }
    }
}

