/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.web;

import com.axelor.apps.production.db.ProductionOrder;
import com.axelor.apps.production.service.productionorder.ProductionOrderSaleOrderService;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.common.base.Joiner;
import com.google.inject.Singleton;
import java.util.List;

@Singleton
public class ProductionOrderSaleOrderController {
    public void createProductionOrders(ActionRequest request, ActionResponse response) throws AxelorException {
        try {
            SaleOrder saleOrder = (SaleOrder)((Object)request.getContext().asType(SaleOrder.class));
            saleOrder = (SaleOrder)((Object)((SaleOrderRepository)((Object)Beans.get(SaleOrderRepository.class))).find(saleOrder.getId()));
            List<Long> productionOrderIdList = ((ProductionOrderSaleOrderService)Beans.get(ProductionOrderSaleOrderService.class)).generateProductionOrder(saleOrder);
            if (productionOrderIdList != null && productionOrderIdList.size() == 1) {
                response.setView(ActionView.define((String)I18n.get((String)"Production order")).model(ProductionOrder.class.getName()).add("form", "production-order-form").add("grid", "production-order-grid").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(productionOrderIdList.get(0))).map());
            } else if (productionOrderIdList != null && productionOrderIdList.size() > 1) {
                response.setView(ActionView.define((String)I18n.get((String)"Production order")).model(ProductionOrder.class.getName()).add("grid", "production-order-grid").add("form", "production-order-form").domain("self.id in (" + Joiner.on((String)",").join(productionOrderIdList) + ")").map());
            } else {
                response.setFlash(I18n.get((String)"No production order could be generated. Make sure that everything has been configured correctly. Reminder: check that the order lines that should be produced have their supply method set to 'produce' and that the chosen BoM has a production process associated to it."));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

