/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.web;

import com.axelor.apps.production.db.ProductionOrder;
import com.axelor.apps.production.service.app.AppProductionService;
import com.axelor.apps.production.service.productionorder.ProductionOrderWizardService;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.inject.Singleton;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;

@Singleton
public class ProductionOrderWizardController {
    public void validate(ActionRequest request, ActionResponse response) throws AxelorException {
        Context context = request.getContext();
        ZonedDateTime startDateT = null;
        ZonedDateTime endDateT = null;
        if (context.get((Object)"_startDate") != null) {
            startDateT = ZonedDateTime.parse(context.get((Object)"_startDate").toString(), DateTimeFormatter.ISO_INSTANT.withZone(ZoneId.systemDefault()));
            if (ChronoUnit.MINUTES.between(((AppProductionService)Beans.get(AppProductionService.class)).getTodayDateTime(), startDateT) < 0L) {
                response.setError(I18n.get((String)"Invalid date"));
            }
        }
        if (context.get((Object)"_endDate") != null) {
            endDateT = ZonedDateTime.parse(context.get((Object)"_endDate").toString(), DateTimeFormatter.ISO_INSTANT.withZone(ZoneId.systemDefault()));
            if (startDateT != null && ChronoUnit.MINUTES.between(startDateT, endDateT) < 0L || ChronoUnit.MINUTES.between(((AppProductionService)Beans.get(AppProductionService.class)).getTodayDateTime(), endDateT) < 0L) {
                response.setError(I18n.get((String)"Invalid date"));
            }
        }
        if (context.get((Object)"qty") == null || new BigDecimal((String)context.get((Object)"qty")).compareTo(BigDecimal.ZERO) <= 0) {
            response.setFlash(I18n.get((String)"You must add a positive quantity") + " !");
        } else if (context.get((Object)"billOfMaterial") == null) {
            response.setFlash(I18n.get((String)"You must select a nomenclature") + " !");
        } else {
            response.setView(ActionView.define((String)I18n.get((String)"Production order generated")).model(ProductionOrder.class.getName()).add("form", "production-order-form").add("grid", "production-order-grid").param("forceEdit", "true").context("_showRecord", (Object)((ProductionOrderWizardService)Beans.get(ProductionOrderWizardService.class)).validate(context).toString()).map());
            response.setCanClose(true);
        }
    }
}

