/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.App;
import com.axelor.auth.db.Group;
import com.axelor.db.EntityHelper;
import com.axelor.db.Model;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.Widget;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_APP_CRM")
@Track(fields={@TrackField(name="assignableUsers", on={TrackEvent.UPDATE}), @TrackField(name="displayCustomerDescriptionInOpportunity", on={TrackEvent.UPDATE})})
public class AppCrm
extends App {
    @Widget(title="Assignable Users", selection="crm.app.crm.assignable.user.select")
    private Integer assignableUsers = 0;
    @Widget(title="Groups Assignable")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Group> groupsAssignable;
    @Widget(title="Display customer description in opportunity")
    private Boolean displayCustomerDescriptionInOpportunity = Boolean.FALSE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Integer getAssignableUsers() {
        return this.assignableUsers == null ? 0 : this.assignableUsers;
    }

    public void setAssignableUsers(Integer assignableUsers) {
        this.assignableUsers = assignableUsers;
    }

    public Set<Group> getGroupsAssignable() {
        return this.groupsAssignable;
    }

    public void setGroupsAssignable(Set<Group> groupsAssignable) {
        this.groupsAssignable = groupsAssignable;
    }

    public void addGroupsAssignable(Group item) {
        if (this.getGroupsAssignable() == null) {
            this.setGroupsAssignable(new HashSet<Group>());
        }
        this.getGroupsAssignable().add(item);
    }

    public void removeGroupsAssignable(Group item) {
        if (this.getGroupsAssignable() == null) {
            return;
        }
        this.getGroupsAssignable().remove((Object)item);
    }

    public void clearGroupsAssignable() {
        if (this.getGroupsAssignable() != null) {
            this.getGroupsAssignable().clear();
        }
    }

    public Boolean getDisplayCustomerDescriptionInOpportunity() {
        return this.displayCustomerDescriptionInOpportunity == null ? Boolean.FALSE : this.displayCustomerDescriptionInOpportunity;
    }

    public void setDisplayCustomerDescriptionInOpportunity(Boolean displayCustomerDescriptionInOpportunity) {
        this.displayCustomerDescriptionInOpportunity = displayCustomerDescriptionInOpportunity;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        return EntityHelper.equals((Model)((Object)this), (Object)obj);
    }

    public int hashCode() {
        return EntityHelper.hashCode((Model)((Object)this));
    }

    public String toString() {
        return EntityHelper.toString((Model)((Object)this));
    }
}

