/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.crm.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Source;
import com.axelor.apps.base.db.TradingName;
import com.axelor.apps.crm.db.Lead;
import com.axelor.apps.crm.db.LostReason;
import com.axelor.apps.crm.db.OpportunityType;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.TrackMessage;
import com.axelor.db.annotations.Widget;
import com.axelor.team.db.Team;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="CRM_OPPORTUNITY", indexes={@Index(columnList="name"), @Index(columnList="partner"), @Index(columnList="currency"), @Index(columnList="opportunity_type"), @Index(columnList="source"), @Index(columnList="company"), @Index(columnList="lead"), @Index(columnList="user_id"), @Index(columnList="team"), @Index(columnList="lost_reason"), @Index(columnList="trading_name")})
@Track(fields={@TrackField(name="name")}, messages={@TrackMessage(message="Opportunity created", condition="true", on={TrackEvent.CREATE}), @TrackMessage(message="Opportunity won", condition="salesStageSelect == 5", tag="success", fields={"salesStageSelect"}), @TrackMessage(message="Opportunity lost", condition="salesStageSelect == 6", tag="warning", fields={"salesStageSelect"})})
public class Opportunity
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="CRM_OPPORTUNITY_SEQ")
    @SequenceGenerator(name="CRM_OPPORTUNITY_SEQ", sequenceName="CRM_OPPORTUNITY_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="Customer")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @Widget(title="Currency")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency currency;
    @Widget(title="Expected close date")
    private LocalDate expectedCloseDate;
    @Widget(title="Amount")
    private BigDecimal amount = BigDecimal.ZERO;
    @Widget(title="Type of need")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private OpportunityType opportunityType;
    @Widget(title="Best case")
    private String bestCase;
    @Widget(title="Worst case")
    private String worstCase;
    @Widget(title="Sales stage", selection="crm.opportunity.sales.stage.select")
    private Integer salesStageSelect = 0;
    @Widget(title="Probability (%)")
    private BigDecimal probability = BigDecimal.ZERO;
    @Widget(title="Next step")
    private String nextStep;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Customer Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String customerDescription;
    @Widget(title="Source")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Source source;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    private Integer orderByState = 0;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String memo;
    @Widget(title="Lead")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Lead lead;
    @Widget(title="Assigned to")
    @JoinColumn(name="user_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;
    @Widget(title="Team")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Team team;
    @Widget(title="Lost reason")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private LostReason lostReason;
    @Widget(title="Lost reason")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String lostReasonStr;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TradingName tradingName;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Opportunity() {
    }

    public Opportunity(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public LocalDate getExpectedCloseDate() {
        return this.expectedCloseDate;
    }

    public void setExpectedCloseDate(LocalDate expectedCloseDate) {
        this.expectedCloseDate = expectedCloseDate;
    }

    public BigDecimal getAmount() {
        return this.amount == null ? BigDecimal.ZERO : this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public OpportunityType getOpportunityType() {
        return this.opportunityType;
    }

    public void setOpportunityType(OpportunityType opportunityType) {
        this.opportunityType = opportunityType;
    }

    public String getBestCase() {
        return this.bestCase;
    }

    public void setBestCase(String bestCase) {
        this.bestCase = bestCase;
    }

    public String getWorstCase() {
        return this.worstCase;
    }

    public void setWorstCase(String worstCase) {
        this.worstCase = worstCase;
    }

    public Integer getSalesStageSelect() {
        return this.salesStageSelect == null ? 0 : this.salesStageSelect;
    }

    public void setSalesStageSelect(Integer salesStageSelect) {
        this.salesStageSelect = salesStageSelect;
    }

    public BigDecimal getProbability() {
        return this.probability == null ? BigDecimal.ZERO : this.probability;
    }

    public void setProbability(BigDecimal probability) {
        this.probability = probability;
    }

    public String getNextStep() {
        return this.nextStep;
    }

    public void setNextStep(String nextStep) {
        this.nextStep = nextStep;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCustomerDescription() {
        return this.customerDescription;
    }

    public void setCustomerDescription(String customerDescription) {
        this.customerDescription = customerDescription;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Integer getOrderByState() {
        return this.orderByState == null ? 0 : this.orderByState;
    }

    public void setOrderByState(Integer orderByState) {
        this.orderByState = orderByState;
    }

    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Lead getLead() {
        return this.lead;
    }

    public void setLead(Lead lead) {
        this.lead = lead;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Team getTeam() {
        return this.team;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    public LostReason getLostReason() {
        return this.lostReason;
    }

    public void setLostReason(LostReason lostReason) {
        this.lostReason = lostReason;
    }

    public String getLostReasonStr() {
        return this.lostReasonStr;
    }

    public void setLostReasonStr(String lostReasonStr) {
        this.lostReasonStr = lostReasonStr;
    }

    public TradingName getTradingName() {
        return this.tradingName;
    }

    public void setTradingName(TradingName tradingName) {
        this.tradingName = tradingName;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Opportunity)) {
            return false;
        }
        Opportunity other = (Opportunity)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("expectedCloseDate", (Object)this.getExpectedCloseDate()).add("amount", (Object)this.getAmount()).add("bestCase", (Object)this.getBestCase()).add("worstCase", (Object)this.getWorstCase()).add("salesStageSelect", (Object)this.getSalesStageSelect()).add("probability", (Object)this.getProbability()).add("nextStep", (Object)this.getNextStep()).add("orderByState", (Object)this.getOrderByState()).omitNullValues().toString();
    }
}

