/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.crm.db;

import com.axelor.apps.base.db.Batch;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.Widget;
import com.axelor.team.db.Team;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="CRM_TARGET_CONFIGURATION", indexes={@Index(columnList="name"), @Index(columnList="code"), @Index(columnList="user_id"), @Index(columnList="team")})
public class TargetConfiguration
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="CRM_TARGET_CONFIGURATION_SEQ")
    @SequenceGenerator(name="CRM_TARGET_CONFIGURATION_SEQ", sequenceName="CRM_TARGET_CONFIGURATION_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    private String name;
    @Widget(title="Code")
    private String code;
    @Widget(title="Assigned to")
    @JoinColumn(name="user_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;
    @Widget(title="Team")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Team team;
    @Widget(title="Amount Won")
    private BigDecimal opportunityAmountWon = BigDecimal.ZERO;
    @Widget(title="Created Nbr")
    private Integer opportunityCreatedNumber = 0;
    @Widget(title="Created Won")
    private Integer opportunityCreatedWon = 0;
    @Widget(title="Call emitted Nbr")
    private Integer callEmittedNumber = 0;
    @Widget(title="Meeting Nbr")
    private Integer meetingNumber = 0;
    @Widget(title="Period type", selection="crm.target.configuration.period.type.select")
    private Integer periodTypeSelect = 0;
    @Widget(title="Date from")
    @NotNull
    private LocalDate fromDate;
    @Widget(title="Date to")
    @NotNull
    private LocalDate toDate;
    @Widget(title="Batchs")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Batch> batchSet;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public TargetConfiguration() {
    }

    public TargetConfiguration(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Team getTeam() {
        return this.team;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    public BigDecimal getOpportunityAmountWon() {
        return this.opportunityAmountWon == null ? BigDecimal.ZERO : this.opportunityAmountWon;
    }

    public void setOpportunityAmountWon(BigDecimal opportunityAmountWon) {
        this.opportunityAmountWon = opportunityAmountWon;
    }

    public Integer getOpportunityCreatedNumber() {
        return this.opportunityCreatedNumber == null ? 0 : this.opportunityCreatedNumber;
    }

    public void setOpportunityCreatedNumber(Integer opportunityCreatedNumber) {
        this.opportunityCreatedNumber = opportunityCreatedNumber;
    }

    public Integer getOpportunityCreatedWon() {
        return this.opportunityCreatedWon == null ? 0 : this.opportunityCreatedWon;
    }

    public void setOpportunityCreatedWon(Integer opportunityCreatedWon) {
        this.opportunityCreatedWon = opportunityCreatedWon;
    }

    public Integer getCallEmittedNumber() {
        return this.callEmittedNumber == null ? 0 : this.callEmittedNumber;
    }

    public void setCallEmittedNumber(Integer callEmittedNumber) {
        this.callEmittedNumber = callEmittedNumber;
    }

    public Integer getMeetingNumber() {
        return this.meetingNumber == null ? 0 : this.meetingNumber;
    }

    public void setMeetingNumber(Integer meetingNumber) {
        this.meetingNumber = meetingNumber;
    }

    public Integer getPeriodTypeSelect() {
        return this.periodTypeSelect == null ? 0 : this.periodTypeSelect;
    }

    public void setPeriodTypeSelect(Integer periodTypeSelect) {
        this.periodTypeSelect = periodTypeSelect;
    }

    public LocalDate getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(LocalDate fromDate) {
        this.fromDate = fromDate;
    }

    public LocalDate getToDate() {
        return this.toDate;
    }

    public void setToDate(LocalDate toDate) {
        this.toDate = toDate;
    }

    public Set<Batch> getBatchSet() {
        return this.batchSet;
    }

    public void setBatchSet(Set<Batch> batchSet) {
        this.batchSet = batchSet;
    }

    public void addBatchSetItem(Batch item) {
        if (this.getBatchSet() == null) {
            this.setBatchSet(new HashSet<Batch>());
        }
        this.getBatchSet().add(item);
    }

    public void removeBatchSetItem(Batch item) {
        if (this.getBatchSet() == null) {
            return;
        }
        this.getBatchSet().remove((Object)item);
    }

    public void clearBatchSet() {
        if (this.getBatchSet() != null) {
            this.getBatchSet().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TargetConfiguration)) {
            return false;
        }
        TargetConfiguration other = (TargetConfiguration)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("code", (Object)this.getCode()).add("opportunityAmountWon", (Object)this.getOpportunityAmountWon()).add("opportunityCreatedNumber", (Object)this.getOpportunityCreatedNumber()).add("opportunityCreatedWon", (Object)this.getOpportunityCreatedWon()).add("callEmittedNumber", (Object)this.getCallEmittedNumber()).add("meetingNumber", (Object)this.getMeetingNumber()).add("periodTypeSelect", (Object)this.getPeriodTypeSelect()).add("fromDate", (Object)this.getFromDate()).add("toDate", (Object)this.getToDate()).omitNullValues().toString();
    }
}

