/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.crm.message;

import com.axelor.apps.base.service.message.MessageServiceBaseImpl;
import com.axelor.apps.base.service.user.UserService;
import com.axelor.apps.crm.db.Event;
import com.axelor.apps.crm.service.config.CrmConfigService;
import com.axelor.apps.message.db.Message;
import com.axelor.apps.message.db.Template;
import com.axelor.apps.message.db.repo.MessageRepository;
import com.axelor.apps.message.service.TemplateMessageService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.axelor.meta.db.repo.MetaAttachmentRepository;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.IOException;

public class MessageServiceCrmImpl
extends MessageServiceBaseImpl {
    @Inject
    public MessageServiceCrmImpl(MetaAttachmentRepository metaAttachmentRepository, MessageRepository messageRepository, UserService userService) {
        super(metaAttachmentRepository, messageRepository, userService);
    }

    @Transactional(rollbackOn={Exception.class})
    public Message createMessage(Event event) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        Template template = null;
        switch (event.getTypeSelect()) {
            case 0: {
                template = ((CrmConfigService)Beans.get(CrmConfigService.class)).getCrmConfig(event.getUser().getActiveCompany()).getEventTemplate();
                break;
            }
            case 1: {
                template = ((CrmConfigService)Beans.get(CrmConfigService.class)).getCrmConfig(event.getUser().getActiveCompany()).getCallTemplate();
                break;
            }
            case 2: {
                template = ((CrmConfigService)Beans.get(CrmConfigService.class)).getCrmConfig(event.getUser().getActiveCompany()).getMeetingTemplate();
                break;
            }
            case 3: {
                template = ((CrmConfigService)Beans.get(CrmConfigService.class)).getCrmConfig(event.getUser().getActiveCompany()).getTaskTemplate();
                break;
            }
        }
        Message message = ((TemplateMessageService)Beans.get(TemplateMessageService.class)).generateMessage((Model)((Object)event), template);
        return (Message)((Object)this.messageRepository.save((Model)((Object)message)));
    }
}

