/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.crm.service;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.base.service.user.UserService;
import com.axelor.apps.crm.db.Event;
import com.axelor.apps.crm.db.Lead;
import com.axelor.apps.crm.db.LostReason;
import com.axelor.apps.crm.db.Opportunity;
import com.axelor.apps.crm.db.repo.EventRepository;
import com.axelor.apps.crm.db.repo.LeadRepository;
import com.axelor.apps.crm.db.repo.OpportunityRepository;
import com.axelor.apps.crm.service.LeadService;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class LeadServiceImpl
implements LeadService {
    @Inject
    protected SequenceService sequenceService;
    @Inject
    protected UserService userService;
    @Inject
    protected PartnerRepository partnerRepo;
    @Inject
    protected OpportunityRepository opportunityRepo;
    @Inject
    protected LeadRepository leadRepo;
    @Inject
    protected EventRepository eventRepo;

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Lead convertLead(Lead lead, Partner partner, Partner contactPartner) throws AxelorException {
        if (partner != null && contactPartner != null) {
            contactPartner = (Partner)this.partnerRepo.save((Model)contactPartner);
            if (partner.getContactPartnerSet() == null) {
                partner.setContactPartnerSet(new HashSet());
            }
            partner.getContactPartnerSet().add(contactPartner);
            contactPartner.setMainPartner(partner);
        }
        if (partner != null) {
            partner = (Partner)this.partnerRepo.save((Model)partner);
            lead.setPartner(partner);
        }
        for (Event event : lead.getEventList()) {
            event.setPartner(partner);
            event.setContactPartner(contactPartner);
            this.eventRepo.save((Model)((Object)event));
        }
        for (Opportunity opportunity : lead.getOpportunitiesList()) {
            opportunity.setPartner(partner);
            this.opportunityRepo.save((Model)((Object)opportunity));
        }
        lead.setStatusSelect(4);
        return (Lead)((Object)this.leadRepo.save((Model)((Object)lead)));
    }

    @Override
    public String getSequence() throws AxelorException {
        String seq = this.sequenceService.getSequenceNumber("partner");
        if (seq == null) {
            throw new AxelorException(4, I18n.get((String)"There is no sequence set for the partners"));
        }
        return seq;
    }

    @Override
    public Partner setPartnerCompany(Partner partner) {
        if (this.userService.getUserActiveCompany() != null) {
            partner.setCompanySet(new HashSet());
            partner.getCompanySet().add(this.userService.getUserActiveCompany());
        }
        return partner;
    }

    @Override
    public Map<String, String> getSocialNetworkUrl(String name, String firstName, String companyName) {
        HashMap<String, String> urlMap = new HashMap<String, String>();
        String searchName = firstName != null && name != null ? firstName + "+" + name : (name == null ? firstName : name);
        searchName = searchName == null ? "" : searchName;
        urlMap.put("facebook", "<a class='fa fa-facebook' href='https://www.facebook.com/search/more/?q=" + searchName + "&init=public' target='_blank'/>");
        urlMap.put("twitter", "<a class='fa fa-twitter' href='https://twitter.com/search?q=" + searchName + "' target='_blank' />");
        urlMap.put("linkedin", "<a class='fa fa-linkedin' href='http://www.linkedin.com/pub/dir/" + searchName.replace("+", "/") + "' target='_blank' />");
        if (companyName != null) {
            urlMap.put("youtube", "<a class='fa fa-youtube' href='https://www.youtube.com/results?search_query=" + companyName + "' target='_blank' />");
            urlMap.put("google", "<a class='fa fa-google' href='https://www.google.com/?gws_rd=cr#q=" + companyName + "+" + searchName + "' target='_blank' />");
        } else {
            urlMap.put("youtube", "<a class='fa fa-youtube' href='https://www.youtube.com/results?search_query=" + searchName + "' target='_blank' />");
            urlMap.put("google", "<a class='fa fa-google' href='https://www.google.com/?gws_rd=cr#q=" + searchName + "' target='_blank' />");
        }
        return urlMap;
    }

    @Override
    @Transactional
    public void saveLead(Lead lead) {
        this.leadRepo.save((Model)((Object)lead));
    }

    @Override
    public Object importLead(Object bean, Map values) {
        assert (bean instanceof Lead);
        Lead lead = (Lead)((Object)bean);
        User user = AuthUtils.getUser();
        lead.setUser(user);
        lead.setTeam(user.getActiveTeam());
        return lead;
    }

    @Override
    public boolean isThereDuplicateLead(Lead lead) {
        String newName = lead.getFullName();
        if (Strings.isNullOrEmpty((String)newName)) {
            return false;
        }
        Long leadId = lead.getId();
        if (leadId == null) {
            Lead existingLead = (Lead)((Object)this.leadRepo.all().filter("lower(self.fullName) = lower(:newName) ").bind("newName", (Object)newName).fetchOne());
            return existingLead != null;
        }
        Lead existingLead = (Lead)((Object)this.leadRepo.all().filter("lower(self.fullName) = lower(:newName) and self.id != :leadId ").bind("newName", (Object)newName).bind("leadId", (Object)leadId).fetchOne());
        return existingLead != null;
    }

    @Override
    @Transactional
    public void loseLead(Lead lead, LostReason lostReason) {
        lead.setStatusSelect(5);
        lead.setLostReason(lostReason);
    }

    @Override
    public String processFullName(String enterpriseName, String name, String firstName) {
        StringBuilder fullName = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)enterpriseName)) {
            fullName.append(enterpriseName);
            if (!Strings.isNullOrEmpty((String)name) || !Strings.isNullOrEmpty((String)firstName)) {
                fullName.append(", ");
            }
        }
        if (!Strings.isNullOrEmpty((String)name) && !Strings.isNullOrEmpty((String)firstName)) {
            fullName.append(firstName);
            fullName.append(" ");
            fullName.append(name);
        } else if (!Strings.isNullOrEmpty((String)firstName)) {
            fullName.append(firstName);
        } else if (!Strings.isNullOrEmpty((String)name)) {
            fullName.append(name);
        }
        return fullName.toString();
    }
}

