/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.crm.service;

import com.axelor.apps.crm.db.Target;
import com.axelor.apps.crm.db.TargetConfiguration;
import com.axelor.apps.crm.db.repo.EventRepository;
import com.axelor.apps.crm.db.repo.OpportunityRepository;
import com.axelor.apps.crm.db.repo.TargetRepository;
import com.axelor.auth.db.User;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.team.db.Team;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import javax.persistence.Query;

public class TargetService {
    @Inject
    private EventRepository eventRepo;
    @Inject
    private OpportunityRepository opportunityRepo;
    @Inject
    private TargetRepository targetRepo;

    public void createsTargets(TargetConfiguration targetConfiguration) throws AxelorException {
        if (targetConfiguration.getPeriodTypeSelect() == 0) {
            Target target = this.createTarget(targetConfiguration, targetConfiguration.getFromDate(), targetConfiguration.getToDate());
            this.update(target);
        } else {
            LocalDate oldDate;
            LocalDate date = oldDate = targetConfiguration.getFromDate();
            while (date.isBefore(targetConfiguration.getToDate()) || date.isEqual(targetConfiguration.getToDate())) {
                date = this.getNextDate(targetConfiguration.getPeriodTypeSelect(), date);
                Target target2 = (Target)((Object)this.targetRepo.all().filter("self.user = ?1 AND self.team = ?2 AND self.periodTypeSelect = ?3 AND self.fromDate >= ?4 AND self.toDate <= ?5 AND ((self.callEmittedNumberTarget > 0 AND ?6 > 0) OR (self.meetingNumberTarget > 0 AND ?7 > 0) OR (self.opportunityAmountWonTarget > 0.00 AND ?8 > 0.00) OR (self.opportunityCreatedNumberTarget > 0 AND ?9 > 0) OR (self.opportunityCreatedWonTarget > 0 AND ?10 > 0))", new Object[]{targetConfiguration.getUser(), targetConfiguration.getTeam(), targetConfiguration.getPeriodTypeSelect(), targetConfiguration.getFromDate(), targetConfiguration.getToDate(), targetConfiguration.getCallEmittedNumber(), targetConfiguration.getMeetingNumber(), targetConfiguration.getOpportunityAmountWon().doubleValue(), targetConfiguration.getOpportunityCreatedNumber(), targetConfiguration.getOpportunityCreatedWon()}).fetchOne());
                if (target2 == null) {
                    Target target = this.createTarget(targetConfiguration, oldDate, date.isBefore(targetConfiguration.getToDate()) ? date.minusDays(1L) : targetConfiguration.getToDate());
                    this.update(target);
                    oldDate = date;
                    continue;
                }
                throw new AxelorException((Model)((Object)targetConfiguration), 4, I18n.get((String)"Objective %s is in contradiction with objective's configuration %s"), new Object[]{target2.getCode(), targetConfiguration.getCode()});
            }
        }
    }

    public LocalDate getNextDate(int periodTypeSelect, LocalDate date) {
        switch (periodTypeSelect) {
            case 0: {
                return date;
            }
            case 1: {
                return date.plusMonths(1L);
            }
            case 2: {
                return date.plusWeeks(1L);
            }
            case 3: {
                return date.plusDays(1L);
            }
        }
        return date;
    }

    @Transactional
    public Target createTarget(TargetConfiguration targetConfiguration, LocalDate fromDate, LocalDate toDate) {
        Target target = new Target();
        target.setCallEmittedNumberTarget(targetConfiguration.getCallEmittedNumber());
        target.setMeetingNumberTarget(targetConfiguration.getMeetingNumber());
        target.setOpportunityAmountWonTarget(targetConfiguration.getOpportunityAmountWon());
        target.setOpportunityCreatedNumberTarget(targetConfiguration.getOpportunityCreatedNumber());
        target.setOpportunityCreatedWonTarget(targetConfiguration.getOpportunityCreatedWon());
        target.setPeriodTypeSelect(targetConfiguration.getPeriodTypeSelect());
        target.setFromDate(fromDate);
        target.setToDate(toDate);
        target.setUser(targetConfiguration.getUser());
        target.setTeam(targetConfiguration.getTeam());
        target.setName(targetConfiguration.getName());
        target.setCode(targetConfiguration.getCode());
        return (Target)((Object)this.targetRepo.save((Model)((Object)target)));
    }

    @Transactional
    public void update(Target target) {
        User user = target.getUser();
        Team team = target.getTeam();
        LocalDate fromDate = target.getFromDate();
        LocalDate toDate = target.getToDate();
        LocalDateTime fromDateTime = fromDate.atStartOfDay();
        LocalDateTime toDateTime = toDate.atTime(23, 59);
        if (user != null) {
            Query q = JPA.em().createQuery("select SUM(op.amount) FROM Opportunity as op WHERE op.user = ?1 AND op.salesStageSelect = ?2 AND op.createdOn >= ?3 AND op.createdOn <= ?4 ");
            q.setParameter(1, (Object)user);
            q.setParameter(2, (Object)5);
            q.setParameter(3, (Object)fromDateTime);
            q.setParameter(4, (Object)toDateTime);
            BigDecimal opportunityAmountWon = (BigDecimal)q.getSingleResult();
            Long callEmittedNumber = this.eventRepo.all().filter("self.typeSelect = ?1 AND self.user = ?2 AND self.startDateTime >= ?3 AND self.endDateTime <= ?4 AND self.callTypeSelect = 2", new Object[]{1, user, fromDateTime, toDateTime}).count();
            target.setCallEmittedNumber(callEmittedNumber.intValue());
            Long meetingNumber = this.eventRepo.all().filter("self.typeSelect = ?1 AND self.user = ?2 AND self.startDateTime >= ?3 AND self.endDateTime <= ?4", new Object[]{2, user, fromDateTime, toDateTime}).count();
            target.setMeetingNumber(meetingNumber.intValue());
            target.setOpportunityAmountWon(opportunityAmountWon);
            Long opportunityCreatedNumber = this.opportunityRepo.all().filter("self.user = ?1 AND self.createdOn >= ?2 AND self.createdOn <= ?3", new Object[]{user, fromDateTime, toDateTime}).count();
            target.setOpportunityCreatedNumber(opportunityCreatedNumber.intValue());
            Long opportunityCreatedWon = this.opportunityRepo.all().filter("self.user = ?1 AND self.createdOn >= ?2 AND self.createdOn <= ?3 AND self.salesStageSelect = ?4", new Object[]{user, fromDateTime, toDateTime, 5}).count();
            target.setOpportunityCreatedWon(opportunityCreatedWon.intValue());
        } else if (team != null) {
            Query q = JPA.em().createQuery("select SUM(op.amount) FROM Opportunity as op WHERE op.team = ?1 AND op.salesStageSelect = ?2  AND op.createdOn >= ?3 AND op.createdOn <= ?4 ");
            q.setParameter(1, (Object)team);
            q.setParameter(2, (Object)5);
            q.setParameter(3, (Object)fromDateTime);
            q.setParameter(4, (Object)toDateTime);
            BigDecimal opportunityAmountWon = (BigDecimal)q.getSingleResult();
            Long callEmittedNumber = this.eventRepo.all().filter("self.typeSelect = ?1 AND self.team = ?2 AND self.startDateTime >= ?3 AND self.endDateTime <= ?4 AND self.callTypeSelect = 2", new Object[]{1, team, fromDateTime, toDateTime}).count();
            target.setCallEmittedNumber(callEmittedNumber.intValue());
            Long meetingNumber = this.eventRepo.all().filter("self.typeSelect = ?1 AND self.team = ?2 AND self.startDateTime >= ?3 AND self.endDateTime <= ?4", new Object[]{2, team, fromDateTime, toDateTime}).count();
            target.setMeetingNumber(meetingNumber.intValue());
            target.setOpportunityAmountWon(opportunityAmountWon);
            Long opportunityCreatedNumber = this.opportunityRepo.all().filter("self.team = ?1 AND self.createdOn >= ?2 AND self.createdOn <= ?3", new Object[]{team, fromDateTime, toDateTime}).count();
            target.setOpportunityCreatedNumber(opportunityCreatedNumber.intValue());
            Long opportunityCreatedWon = this.opportunityRepo.all().filter("self.team = ?1 AND self.createdOn >= ?2 AND self.createdOn <= ?3 AND self.salesStageSelect = ?4", new Object[]{team, fromDateTime, toDateTime, 5}).count();
            target.setOpportunityCreatedWon(opportunityCreatedWon.intValue());
        }
        this.targetRepo.save((Model)((Object)target));
    }
}

