/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.crm.service.batch;

import com.axelor.apps.crm.db.TargetConfiguration;
import com.axelor.apps.crm.db.repo.TargetConfigurationRepository;
import com.axelor.apps.crm.service.TargetService;
import com.axelor.apps.crm.service.batch.BatchStrategy;
import com.axelor.db.JPA;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchTarget
extends BatchStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Inject
    private TargetConfigurationRepository targetConfigurationRepo;

    @Inject
    public BatchTarget(TargetService targetService) {
        super(targetService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process() {
        int i = 0;
        ArrayList<TargetConfiguration> targetConfigurationList = new ArrayList<TargetConfiguration>();
        if (this.batch.getCrmBatch().getTargetConfigurationSet() != null && !this.batch.getCrmBatch().getTargetConfigurationSet().isEmpty()) {
            targetConfigurationList.addAll(this.batch.getCrmBatch().getTargetConfigurationSet());
        }
        for (TargetConfiguration targetConfiguration : targetConfigurationList) {
            try {
                this.targetService.createsTargets(targetConfiguration);
                this.updateTargetConfiguration(targetConfiguration);
                ++i;
            }
            catch (Exception e) {
                TraceBackService.trace((Throwable)new Exception(String.format(I18n.get((String)"Event reminder %s"), ((TargetConfiguration)((Object)this.targetConfigurationRepo.find(targetConfiguration.getId()))).getCode()), e), (String)"crm", (long)this.batch.getId());
                this.incrementAnomaly();
                LOG.error("Bug(Anomalie) g\u00e9n\u00e9r\u00e9(e) pour le rappel de l'\u00e9v\u00e8nement {}", (Object)((TargetConfiguration)((Object)this.targetConfigurationRepo.find(targetConfiguration.getId()))).getCode());
            }
            finally {
                if (i % 1 != 0) continue;
                JPA.clear();
            }
        }
    }

    protected void stop() {
        String comment = I18n.get((String)"Objectives' generation's reporting :") + "\n";
        comment = comment + String.format("\t* %s " + I18n.get((String)"Treated objectives reporting") + "\n", this.batch.getDone());
        comment = comment + String.format("\t" + I18n.get((String)"* %s anomaly(ies)"), this.batch.getAnomaly());
        super.stop();
        this.addComment(comment);
    }
}

